/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.action.LabelType;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.AbstractMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Confirm;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButtonCondition;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeAction;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Button;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.ButtonCondition;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Group;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.MenuItem;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class ToolbarCompiler
implements BaseSourceCompiler<Toolbar, N2oToolbar, CompileContext<?, ?>>,
SourceClassAware,
MetadataEnvironmentAware {
    protected ButtonGeneratorFactory buttonGeneratorFactory;

    public Toolbar compile(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p) {
        Toolbar toolbar = new Toolbar();
        ArrayList<Group> groups = new ArrayList<Group>();
        IndexScope index = (IndexScope)p.getScope(IndexScope.class);
        this.initGenerate(source, context, p);
        int i = 0;
        if (source.getItems() == null) {
            return toolbar;
        }
        String defaultPlace = null;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        defaultPlace = widgetScope != null ? Placeholders.property((String)"n2o.api.widget.toolbar.place") : Placeholders.property((String)"n2o.api.page.toolbar.place");
        String place = (String)p.cast((Object)source.getPlace(), (Object)((String)p.resolve(defaultPlace, String.class)), new Object[0]);
        int gi = 0;
        while (i < source.getItems().length) {
            Group gr = new Group(place + gi);
            ArrayList<Button> buttons = new ArrayList<Button>();
            ToolbarItem item = source.getItems()[i];
            if (item instanceof N2oGroup) {
                N2oGroup group = (N2oGroup)item;
                if (group.getGenerate() != null) {
                    for (String string : group.getGenerate()) {
                        this.buttonGeneratorFactory.generate(string.trim(), source, context, p).forEach(j -> buttons.add(this.getButton(source, (ToolbarItem)j, index, context, p)));
                    }
                } else {
                    for (String string : group.getItems()) {
                        buttons.add(this.getButton(source, (ToolbarItem)string, index, context, p));
                    }
                }
                ++i;
            } else {
                while (i < source.getItems().length && !(source.getItems()[i] instanceof N2oGroup)) {
                    buttons.add(this.getButton(source, source.getItems()[i], index, context, p));
                    ++i;
                }
            }
            gr.setButtons(buttons);
            groups.add(gr);
            ++gi;
        }
        toolbar.put((Object)place, groups);
        return toolbar;
    }

    protected void initItem(MenuItem button, AbstractMenuItem source, IndexScope idx, CompileContext<?, ?> context, CompileProcessor p) {
        button.setId(CompileUtil.castDefault((String)source.getId(), (String)source.getActionId(), (String[])new String[]{"menuItem" + idx.get()}));
        source.setId(button.getId());
        button.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        if (source.getType() != null && source.getType().equals((Object)LabelType.icon)) {
            button.setIcon(source.getIcon());
        } else if (source.getType() != null && source.getType().equals((Object)LabelType.text)) {
            button.setLabel(source.getLabel());
        } else {
            button.setIcon(source.getIcon());
            button.setLabel(source.getLabel());
        }
        CompiledObject.Operation operation = null;
        if (source.getActionId() == null) {
            N2oAction butAction = source.getAction();
            if (butAction != null) {
                butAction.setId((String)p.cast((Object)butAction.getId(), (Object)button.getId(), new Object[0]));
                Action action = (Action)p.compile((Object)butAction, context, new Object[]{new ComponentScope(source)});
                button.setActionId(action.getId());
                if (action instanceof InvokeAction) {
                    CompiledObject compiledObject = (CompiledObject)p.getScope(CompiledObject.class);
                    operation = compiledObject != null && compiledObject.getOperations() != null ? (CompiledObject.Operation)compiledObject.getOperations().get(((InvokeAction)action).getOperationId()) : null;
                }
            }
        } else {
            button.setActionId(source.getActionId());
        }
        this.initConfirm(button, source, context, p, operation);
        button.setClassName(source.getClassName());
        String hint = LabelType.icon.equals((Object)source.getType()) ? (String)p.cast((Object)source.getDescription(), (Object)source.getLabel(), new Object[0]) : source.getDescription();
        if (hint != null) {
            button.setHint(hint.trim());
            if (source.getTooltipPosition() != null) {
                button.setHintPosition(source.getTooltipPosition());
            } else {
                button.setHintPosition(source instanceof N2oButton ? (String)p.resolve(Placeholders.property((String)"n2o.api.button.tooltip_position"), String.class) : (String)p.resolve(Placeholders.property((String)"n2o.api.menuitem.tooltip_position"), String.class));
            }
        }
        button.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
        button.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
        if (source.getModel() == null) {
            source.setModel(ReduxModel.RESOLVE);
        }
        this.compileDependencies(button, source, context, p);
        button.setValidate(source.getValidate());
    }

    private void initConfirm(MenuItem button, AbstractMenuItem source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject.Operation operation) {
        if (!(source.getConfirm() != null && source.getConfirm().booleanValue() || source.getConfirm() == null && operation != null && operation.getConfirm() != null && operation.getConfirm().booleanValue())) {
            return;
        }
        Confirm confirm = new Confirm();
        confirm.setText((String)p.cast((Object)source.getConfirmText(), (Object)(operation != null ? operation.getConfirmationText() : null), new Object[]{p.getMessage("n2o.confirm.text", new Object[0])}));
        confirm.setTitle((String)p.cast((Object)source.getConfirmTitle(), (Object)(operation != null ? operation.getFormSubmitLabel() : null), new Object[]{p.getMessage("n2o.confirm.title", new Object[0])}));
        confirm.setOkLabel((String)p.cast((Object)source.getConfirmOkLabel(), (Object)p.getMessage("n2o.confirm.default.okLabel", new Object[0]), new Object[0]));
        confirm.setCancelLabel((String)p.cast((Object)source.getConfirmCancelLabel(), (Object)p.getMessage("n2o.confirm.default.cancelLabel", new Object[0]), new Object[0]));
        if (StringUtils.hasLink((String)confirm.getText())) {
            Set links = StringUtils.collectLinks((String)confirm.getText());
            String text = Placeholders.js((String)("'" + confirm.getText() + "'"));
            for (String link : links) {
                text = text.replace(Placeholders.ref((String)link), "' + this." + link + " + '");
            }
            confirm.setText(text);
        }
        if (StringUtils.isJs((Object)confirm.getText())) {
            String widgetId = this.initWidgetId(source, context, p);
            ReduxModel reduxModel = source.getModel();
            confirm.setModelLink(new ModelLink(reduxModel == null ? ReduxModel.RESOLVE : reduxModel, widgetId).getBindLink());
        }
        button.setConfirm(confirm);
    }

    protected void compileDependencies(MenuItem button, AbstractMenuItem source, CompileContext<?, ?> context, CompileProcessor p) {
        String widgetId;
        ButtonCondition condition;
        if (source.getVisibilityConditions() != null) {
            String widgetId2 = this.initWidgetId(source, context, p);
            ArrayList<ButtonCondition> conditions = new ArrayList<ButtonCondition>();
            for (N2oButtonCondition n2oCondition : source.getVisibilityConditions()) {
                condition = new ButtonCondition();
                condition.setExpression(n2oCondition.getExpression().trim());
                condition.setModelLink(new ModelLink(source.getModel(), widgetId2).getBindLink());
                conditions.add(condition);
            }
            button.getConditions().put(ValidationType.visible, conditions);
        }
        ArrayList<ButtonCondition> conditions = new ArrayList<ButtonCondition>();
        if (source.getEnablingConditions() != null) {
            widgetId = this.initWidgetId(source, context, p);
            for (N2oButtonCondition n2oCondition : source.getEnablingConditions()) {
                condition = new ButtonCondition();
                condition.setExpression(n2oCondition.getExpression().trim());
                condition.setModelLink(new ModelLink(source.getModel(), widgetId).getBindLink());
                conditions.add(condition);
            }
        }
        if (source.getModel() == null || source.getModel().equals((Object)ReduxModel.RESOLVE)) {
            widgetId = this.initWidgetId(source, context, p);
            ButtonCondition condition2 = new ButtonCondition();
            condition2.setExpression("!_.isEmpty(this)");
            condition2.setModelLink(new ModelLink(ReduxModel.RESOLVE, widgetId).getBindLink());
            conditions.add(condition2);
        }
        if (!conditions.isEmpty()) {
            button.getConditions().put(ValidationType.enabled, conditions);
        }
    }

    protected String initWidgetId(AbstractMenuItem source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (source.getWidgetId() != null) {
            return pageScope == null ? source.getWidgetId() : pageScope.getGlobalWidgetId(source.getWidgetId());
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getClientWidgetId();
        }
        if (context instanceof PageContext && ((PageContext)context).getResultWidgetId() != null) {
            return pageScope.getGlobalWidgetId(((PageContext)context).getResultWidgetId());
        }
        throw new N2oException("Unknown widgetId for invoke action!");
    }

    protected Button getButton(N2oToolbar source, ToolbarItem item, IndexScope idx, CompileContext<?, ?> context, CompileProcessor p) {
        Button button = new Button();
        if (item instanceof N2oButton) {
            N2oButton but = (N2oButton)item;
            button.setProperties(p.mapAttributes((ExtensionAttributesAware)but));
            button.setColor(but.getColor());
            button.setDropdownSrc(but.getDropdownSrc());
            this.initItem((MenuItem)button, (AbstractMenuItem)but, idx, context, p);
            if (but.getValidate() != null && but.getValidate().booleanValue()) {
                button.setValidatedWidgetId(this.initWidgetId((AbstractMenuItem)but, context, p));
            }
        } else if (item instanceof N2oSubmenu) {
            N2oSubmenu sub = (N2oSubmenu)item;
            button.setId(sub.getId() == null ? "subMenu" + idx.get() : sub.getId());
            button.setLabel(sub.getLabel());
            button.setClassName(sub.getClassName());
            button.setColor(sub.getColor());
            if (sub.getDescription() != null) {
                button.setHint(sub.getDescription().trim());
            }
            button.setIcon(sub.getIcon());
            button.setVisible((Object)sub.getVisible());
            if (sub.getMenuItems() != null) {
                button.setSubMenu(Stream.of(sub.getMenuItems()).map(mi -> {
                    MenuItem menuItem = new MenuItem();
                    this.initItem(menuItem, (AbstractMenuItem)mi, idx, context, p);
                    return menuItem;
                }).collect(Collectors.toList()));
            }
            if (sub.getGenerate() != null) {
                if (button.getSubMenu() == null) {
                    button.setSubMenu(new ArrayList());
                }
                for (String generate : sub.getGenerate()) {
                    for (ToolbarItem toolbarItem : this.buttonGeneratorFactory.generate(generate.trim(), source, context, p)) {
                        MenuItem menuItem = new MenuItem();
                        button.getSubMenu().add(menuItem);
                        this.initItem(menuItem, (AbstractMenuItem)((N2oButton)toolbarItem), idx, context, p);
                    }
                }
            }
        }
        return button;
    }

    private ToolbarItem[] push(N2oToolbar source, N2oButton button) {
        ToolbarItem[] items;
        if (source.getItems() == null) {
            items = new ToolbarItem[]{button};
        } else {
            int length = source.getItems().length;
            items = new ToolbarItem[length + 1];
            System.arraycopy(source.getItems(), 0, items, 0, length);
            items[length] = button;
        }
        return items;
    }

    protected void initGenerate(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getGenerate() != null) {
            for (String generate : source.getGenerate()) {
                this.buttonGeneratorFactory.generate(generate.trim(), source, context, p).forEach(i -> source.setItems(this.push(source, (N2oButton)i)));
            }
        }
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.buttonGeneratorFactory = environment.getButtonGeneratorFactory();
    }

    public Class<? extends Source> getSourceClass() {
        return N2oToolbar.class;
    }
}

