/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oRowClick;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oTable;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.AbstractColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oSimpleColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oTextCell;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.api.metadata.meta.widget.table.AbstractTable;
import net.n2oapp.framework.api.metadata.meta.widget.table.ColumnHeader;
import net.n2oapp.framework.api.metadata.meta.widget.table.Scroll;
import net.n2oapp.framework.api.metadata.meta.widget.table.Table;
import net.n2oapp.framework.api.metadata.meta.widget.table.TableWidgetComponent;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.UploadScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class TableCompiler
extends BaseWidgetCompiler<Table, N2oTable> {
    public Class<? extends Source> getSourceClass() {
        return N2oTable.class;
    }

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.table.src";
    }

    public Table compile(N2oTable source, CompileContext<?, ?> context, CompileProcessor p) {
        Table table = new Table();
        TableWidgetComponent component = table.getComponent();
        CompiledQuery query = this.getQuery(source, p);
        CompiledObject object = this.getObject(source, p);
        this.compileWidget(table, source, context, p, object);
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setClientWidgetId(table.getId());
        widgetScope.setWidgetId(source.getId());
        widgetScope.setQueryId(source.getQueryId());
        Models models = (Models)p.getScope(Models.class);
        SubModelsScope subModelsScope = new SubModelsScope();
        UploadScope uploadScope = new UploadScope();
        uploadScope.setUpload(UploadType.defaults);
        table.setFilter(this.createFilter(source, context, p, widgetScope, query, object, new ModelsScope(ReduxModel.FILTER, table.getId(), models), new FiltersScope(table.getFilters()), subModelsScope, uploadScope, new MomentScope(N2oValidation.ServerMoment.beforeQuery)));
        ValidationList validationList = p.getScope(ValidationList.class) == null ? new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>()) : (ValidationList)p.getScope(ValidationList.class);
        ValidationScope validationScope = new ValidationScope(table.getId(), ReduxModel.FILTER, validationList);
        this.compileValidation(table, source, validationScope);
        ParentRouteScope widgetRouteScope = this.initWidgetRouteScope(table, context, p);
        PageRoutesScope pageRoutesScope = (PageRoutesScope)p.getScope(PageRoutesScope.class);
        if (pageRoutesScope != null) {
            pageRoutesScope.put(table.getId(), widgetRouteScope);
        }
        this.compileDataProviderAndRoutes(table, source, p, validationList, widgetRouteScope, null, null);
        component.setSize(source.getSize() != null ? source.getSize() : (Integer)p.resolve("${n2o.api.default.widget.table.size}", Integer.class));
        component.setClassName(source.getCssClass());
        component.setTableSize(source.getTableSize() != null ? source.getTableSize().name().toLowerCase() : null);
        if (source.getScrollX() != null || source.getScrollY() != null) {
            component.setScroll(new Scroll());
            component.getScroll().setX(source.getScrollX());
            component.getScroll().setY(source.getScrollY());
        }
        MetaActions widgetActions = new MetaActions();
        this.compileToolbarAndAction(table, source, context, p, widgetScope, widgetRouteScope, widgetActions, object, null);
        if (source.getRows() != null) {
            if (source.getRows().getRowClass() != null) {
                component.setRowClass(p.resolveJS(source.getRows().getRowClass()));
            } else if (source.getRows().getColor() != null) {
                HashMap<Object, String> resolvedCases = new HashMap<Object, String>();
                for (String key : source.getRows().getColor().getCases().keySet()) {
                    resolvedCases.put(p.resolve(key), (String)source.getRows().getColor().getCases().get(key));
                }
                source.getRows().getColor().setResolvedCases(resolvedCases);
                component.setRowClass(ScriptProcessor.buildSwitchExpression((N2oSwitch)source.getRows().getColor()));
            }
            this.compileRowClick(source, component, context, p, widgetScope, widgetRouteScope);
        }
        this.compileColumns(source, context, p, component, query, object, widgetScope, widgetRouteScope, widgetActions);
        Boolean prev = null;
        Boolean next = null;
        if (source.getPagination() != null) {
            prev = source.getPagination().getPrev();
            next = source.getPagination().getNext();
        }
        table.setPaging(this.createPaging(source.getSize(), prev, next, "n2o.api.default.widget.table.size", p));
        return table;
    }

    private void compileRowClick(N2oTable source, TableWidgetComponent component, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, ParentRouteScope widgetRouteScope) {
        N2oRowClick rowClick = source.getRows().getRowClick();
        if (rowClick != null) {
            if (rowClick.getActionId() != null) {
                MetaActions actions = (MetaActions)((Object)p.getScope(MetaActions.class));
                Action action = (Action)actions.get(rowClick.getActionId());
                component.setRowClick(action);
            } else if (rowClick.getAction() != null) {
                Action action = (Action)p.compile((Object)rowClick.getAction(), context, new Object[]{widgetScope, widgetRouteScope, new ComponentScope(rowClick)});
                component.setRowClick(action);
            }
        }
    }

    @Override
    protected QueryContext getQueryContext(Table widget, N2oTable source, String route, CompiledQuery query, ValidationList validationList, SubModelsScope subModelsScope, CopiedFieldScope copiedFieldScope, CompileProcessor p) {
        QueryContext queryContext = super.getQueryContext(widget, source, route, query, validationList, subModelsScope, copiedFieldScope, p);
        queryContext.setSortingMap((Map<String, String>)new StrictMap());
        if (source.getColumns() != null) {
            for (AbstractColumn column : source.getColumns()) {
                String id = column.getId() != null ? column.getId() : column.getTextFieldId();
                String sortingFieldId = column.getSortingFieldId() != null ? column.getSortingFieldId() : column.getTextFieldId();
                queryContext.getSortingMap().put(id, sortingFieldId);
            }
        }
        return queryContext;
    }

    @Override
    protected String getMessagesForm(Widget widget) {
        return widget.getId() + "_filter";
    }

    private void compileValidation(Table table, N2oTable source, ValidationScope validationScope) {
        if (source.getFilters() == null) {
            return;
        }
        HashMap clientValidations = new HashMap();
        table.getFilter().getFilterFieldsets().forEach(fs -> this.collectValidation((FieldSet)fs, clientValidations, validationScope));
        table.getFilter().setValidation(clientValidations);
    }

    private void compileColumns(N2oTable source, CompileContext<?, ?> context, CompileProcessor p, TableWidgetComponent component, CompiledQuery query, CompiledObject object, WidgetScope widgetScope, ParentRouteScope widgetRouteScope, MetaActions widgetActions) {
        if (source.getColumns() != null) {
            ArrayList<ColumnHeader> headers = new ArrayList<ColumnHeader>();
            ArrayList<N2oCell> cells = new ArrayList<N2oCell>();
            HashMap<String, String> sortings = new HashMap<String, String>();
            IndexScope columnIndex = new IndexScope();
            for (AbstractColumn column : source.getColumns()) {
                this.compileHeaderWithCell(object, query, headers, cells, column, context, p, columnIndex, widgetScope, widgetRouteScope, widgetActions);
                if (column.getSortingDirection() == null) continue;
                sortings.put(column.getTextFieldId(), column.getSortingDirection().toString().toUpperCase());
            }
            component.setHeaders(headers);
            component.setCells(cells);
            component.setSorting(sortings);
            Boolean hasSelect = (Boolean)p.cast((Object)source.getSelected(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.selected"), Boolean.class)), new Object[0]);
            component.setHasSelect(hasSelect);
            component.setHasFocus(hasSelect);
        }
    }

    private void compileHeaderWithCell(CompiledObject object, CompiledQuery query, List<ColumnHeader> headers, List<N2oCell> cells, AbstractColumn column, CompileContext<?, ?> context, CompileProcessor p, IndexScope columnIndex, WidgetScope widgetScope, ParentRouteScope widgetRouteScope, MetaActions widgetActions) {
        ColumnHeader header = new ColumnHeader();
        column.setId((String)p.cast((Object)column.getId(), (Object)column.getTextFieldId(), new Object[0]));
        column.setSortingFieldId((String)p.cast((Object)column.getSortingFieldId(), (Object)column.getTextFieldId(), new Object[0]));
        header.setId(column.getId());
        header.setIcon(column.getLabelIcon());
        header.setWidth(column.getWidth());
        header.setResizable(column.getResizable());
        header.setFixed(column.getFixed());
        if (query != null && query.getFieldsMap().containsKey(column.getTextFieldId())) {
            header.setLabel((String)p.cast((Object)column.getLabelName(), (Object)((N2oQuery.Field)query.getFieldsMap().get(column.getTextFieldId())).getName(), new Object[0]));
        } else {
            header.setLabel(column.getLabelName());
        }
        if (query != null && query.getFieldsMap().containsKey(header.getId())) {
            header.setSortable(Boolean.valueOf(((N2oQuery.Field)query.getFieldsMap().get(header.getId())).getNoSorting() == false));
        }
        headers.add(header);
        if (column instanceof N2oSimpleColumn) {
            N2oCell cell = ((N2oSimpleColumn)column).getCell();
            if (cell == null) {
                cell = new N2oTextCell();
            }
            cell = (N2oCell)p.compile((Object)cell, context, new Object[]{columnIndex, widgetScope, widgetRouteScope, new ComponentScope(column), object, widgetActions});
            cells.add(cell);
        }
    }

    private AbstractTable.Filter createFilter(N2oTable source, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, CompiledQuery widgetQuery, CompiledObject object, ModelsScope modelsScope, FiltersScope filtersScope, SubModelsScope subModelsScope, UploadScope uploadScope, MomentScope momentScope) {
        List<FieldSet> fieldSets = this.initFieldSets(source.getFilters(), context, p, widgetScope, widgetQuery, object, modelsScope, filtersScope, subModelsScope, uploadScope, momentScope, null);
        if (fieldSets.isEmpty()) {
            return null;
        }
        AbstractTable.Filter filter = new AbstractTable.Filter();
        filter.setFilterFieldsets(fieldSets);
        filter.setFilterButtonId("filter");
        filter.setBlackResetList(Collections.EMPTY_LIST);
        filter.setFilterPlace((N2oTable.FilterPosition)p.cast((Object)source.getFilterPosition(), (Object)N2oTable.FilterPosition.top, new Object[0]));
        filter.setHideButtons((Boolean)p.cast((Object)source.getSearchButtons(), (Object)true, new Object[0]) != false ? null : Boolean.valueOf(true));
        return filter;
    }
}

