/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.control;

import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.control.list.GroupClassifierMode;
import net.n2oapp.framework.api.metadata.control.list.GroupFieldAware;
import net.n2oapp.framework.api.metadata.control.list.InfoFieldAware;
import net.n2oapp.framework.api.metadata.control.list.N2oGroupClassifierMulti;
import net.n2oapp.framework.api.metadata.control.list.N2oGroupClassifierSingle;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.control.N2oStandardControlReaderV1;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.stereotype.Component;

@Component
public class N2oGroupClassifierXmlReaderV1
extends N2oStandardControlReaderV1<N2oListField> {
    public String getElementName() {
        return "group-classifier";
    }

    public N2oListField read(Element element, Namespace namespace) {
        GroupClassifierMode mode = ReaderJdomUtil.getAttributeEnum(element, "mode", GroupClassifierMode.class);
        if (mode == null) {
            throw new MetadataReaderException("n2o.attributeIsMissing").addData(new Object[]{"[mode]"});
        }
        N2oGroupClassifierSingle groupClassifier = new N2oGroupClassifierSingle();
        if (mode.getId().equals("single")) {
            groupClassifier = new N2oGroupClassifierSingle();
        } else if (mode.getId().equals("multi")) {
            groupClassifier = new N2oGroupClassifierMulti();
            ((N2oGroupClassifierMulti)groupClassifier).setMode(GroupClassifierMode.MULTI);
        } else if (mode.getId().equals("multi-checkbox")) {
            groupClassifier = new N2oGroupClassifierMulti();
            ((N2oGroupClassifierMulti)groupClassifier).setMode(GroupClassifierMode.MULTI_CHECKBOX);
        }
        ((GroupFieldAware)groupClassifier).setGroupFieldId(ReaderJdomUtil.getAttributeString(element, "group-field-id"));
        ((InfoFieldAware)groupClassifier).setInfoFieldId(ReaderJdomUtil.getAttributeString(element, "info-field-id"));
        ((InfoFieldAware)groupClassifier).setInfoStyle(ReaderJdomUtil.getAttributeString(element, "info-style"));
        return this.getQueryFieldDefinition(element, groupClassifier);
    }

    public Class<N2oListField> getElementClass() {
        return N2oListField.class;
    }
}

