/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.tools;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom.Element;
import org.jdom.Namespace;

public class PropertiesReaderV1 {
    private static final PropertiesReaderV1 instance = new PropertiesReaderV1();

    private PropertiesReaderV1() {
    }

    public static PropertiesReaderV1 getInstance() {
        return instance;
    }

    public Map<String, Object> readFromPropertiesElement(Element element, Namespace namespace) {
        LinkedHashMap<String, Object> res = null;
        if (element != null) {
            List properties = element.getChildren("property", namespace);
            res = new LinkedHashMap<String, Object>();
            for (Element property : properties) {
                String key = ReaderJdomUtil.getAttributeString(property, "key");
                String value = ReaderJdomUtil.getAttributeString(property, "value");
                String domain = ReaderJdomUtil.getAttributeString(property, "domain");
                Object object = DomainProcessor.getInstance().doDomainConversion(domain, (Object)value);
                res.put(key, object);
            }
        }
        return res;
    }

    public Map<String, Object> read(Element element, Namespace namespace) {
        if (element == null) {
            return null;
        }
        Element propertiesElement = element.getChild("properties", namespace);
        return this.readFromPropertiesElement(propertiesElement, namespace);
    }
}

