/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.scanner;

import java.util.List;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.springframework.stereotype.Component;

@Component
public class XmlInfoScanner
implements MetadataScanner<InfoConstructor>,
MetadataEnvironmentAware {
    public static final String DEFAULT_PATTERN = "classpath*:META-INF/conf/**/*.xml";
    private String pattern = "classpath*:META-INF/conf/**/*.xml";
    private SourceTypeRegister sourceTypeRegister;

    public XmlInfoScanner() {
    }

    public XmlInfoScanner(String pattern) {
        this.pattern = pattern;
    }

    public XmlInfoScanner(String pattern, SourceTypeRegister sourceTypeRegister) {
        this.pattern = pattern;
        this.sourceTypeRegister = sourceTypeRegister;
    }

    public List<InfoConstructor> scan() {
        List<InfoConstructor> infoConstructors = RegisterUtil.collectInfo(FileSystemUtil.getNodesByLocationPattern(this.pattern), node -> RegisterUtil.createXmlInfo(node, this.sourceTypeRegister));
        return infoConstructors;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.sourceTypeRegister = environment.getSourceTypeRegister();
    }

    public SourceTypeRegister getSourceTypeRegister() {
        return this.sourceTypeRegister;
    }
}

