/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.config.register.storage.Node;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PathUtil {
    public static String concatFileNameAndBasePath(String fileName, String basePath) {
        return basePath != null ? (basePath.endsWith("/") ? basePath + fileName : basePath + "/" + fileName) : fileName;
    }

    public static String convertPathToClasspathUri(String path) {
        return PathUtil.isUri(path) ? path : "classpath:" + path;
    }

    public static String convertRootPathToUrl(String rootPath) {
        String prefixFile = "file:/";
        if (!(rootPath = rootPath.replace('\\', '/')).endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if (rootPath.startsWith("/")) {
            rootPath = rootPath.substring(1);
        }
        if (!PathUtil.isUri(rootPath)) {
            return prefixFile + rootPath;
        }
        rootPath = PathUtil.replacePathPatternAttribute(rootPath);
        return rootPath;
    }

    private static String replacePathPatternAttribute(String rootPath) {
        String pathPatternAttribute = "**/*.";
        rootPath = rootPath.contains(pathPatternAttribute) ? rootPath.substring(0, rootPath.indexOf(pathPatternAttribute)) : rootPath;
        return rootPath;
    }

    public static String convertUrlToAbsolutePath(String url) {
        String prefixFile = "file:";
        Boolean isOutsidePath = url.startsWith(prefixFile);
        if (!isOutsidePath.booleanValue()) {
            return null;
        }
        url = (url = url.substring(prefixFile.length())).contains("*") ? url.substring(0, url.indexOf("*")) : url;
        return url;
    }

    public static String convertUrlToPattern(String url, String fileExtension) {
        return PathUtil.convertUrlToPattern(url, fileExtension, "*");
    }

    public static String convertUrlToPattern(String url, String fileExtension, String fileNamePattern) {
        if (fileExtension != null && !url.endsWith("." + fileExtension)) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + "**/" + fileNamePattern + "." + fileExtension;
        }
        return url;
    }

    public static String convertRootPathToFilePathPattern(String rootPath, String localPath) {
        String rootUrl = PathUtil.convertRootPathToUrl(rootPath);
        return PathUtil.concatAbsoluteAndLocalPath(rootUrl, localPath);
    }

    public static String concatAbsoluteAndLocalPath(String absolutePath, String localPath) {
        if (!absolutePath.endsWith("/")) {
            absolutePath = absolutePath + "/";
        }
        if (localPath.startsWith("/")) {
            localPath = localPath.substring(1, localPath.length());
        }
        return (absolutePath + localPath).replace("\\", "/");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource getContentByPathPattern(String path) {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource resource = null;
        if (!path.contains("*")) return resourcePatternResolver.getResource(path);
        try {
            Resource[] resources = resourcePatternResolver.getResources(path);
            if (resources.length == 0) return resource;
            if (!resources[0].exists()) return resource;
            return resources[0];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> extractDirs(String absolutePath) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (absolutePath == null) {
            return dirs;
        }
        File file = new File(absolutePath);
        if (file.exists()) {
            PathUtil.getDirs(absolutePath, file, dirs, false);
        }
        return dirs;
    }

    private static void getDirs(String absolutePath, File dir, List<String> result, boolean include) {
        if (dir.isDirectory()) {
            String[] subElements;
            if (include) {
                result.add(Node.calculateLocalPathByDirectoryPath(absolutePath, dir.getAbsolutePath()));
            }
            for (String subElement : subElements = dir.list()) {
                PathUtil.getDirs(absolutePath, new File(dir, subElement), result, true);
            }
        }
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        String normalized = Paths.get(path, new String[0]).toAbsolutePath().toString();
        if (normalized.endsWith("/")) {
            normalized = normalized.substring(normalized.length() - 1);
        }
        return normalized;
    }

    public static boolean isUri(String path) {
        return path != null && (path.startsWith("file") || path.startsWith("classpath") || path.startsWith("jar") || path.startsWith("war") || path.startsWith("ear") || path.startsWith("http") || path.startsWith("https"));
    }

    public static String convertAbsolutePathToLocalPath(String absolutePath, String configPath) {
        absolutePath = PathUtil.normalize(absolutePath);
        configPath = PathUtil.normalize(configPath);
        return absolutePath.substring(absolutePath.indexOf(configPath) + configPath.length() + 1).replace("\\", "/");
    }
}

