/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective.reader;

import java.util.HashMap;
import java.util.Map;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.framework.api.metadata.aware.ReaderFactoryAware;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import org.jdom.Namespace;

public class ReaderFactoryByMap
implements NamespaceReaderFactory,
IOProcessorAware {
    private Map<String, Map<String, NamespaceReader>> map = new HashMap<String, Map<String, NamespaceReader>>();
    private IOProcessor ioProcessor = new IOProcessorImpl(this);

    public ReaderFactoryByMap register(NamespaceReader reader) {
        this.add(reader);
        return this;
    }

    public ReaderFactoryByMap register(NamespaceIO io) {
        return this.register((NamespaceReader)new ProxyNamespaceIO(io, this.ioProcessor));
    }

    public NamespaceReader produce(Namespace namespace, String elementName) {
        Map<String, NamespaceReader> innerEngines = this.map.get(namespace.getURI());
        if (innerEngines == null) {
            throw new EngineNotFoundException((Object)namespace.getURI());
        }
        NamespaceReader reader = innerEngines.get(elementName);
        if (reader == null) {
            throw new EngineNotFoundException((Object)elementName);
        }
        if (reader instanceof ReaderFactoryAware) {
            ((ReaderFactoryAware)reader).setReaderFactory((NamespaceReaderFactory)this);
        }
        if (reader instanceof IOProcessorAware) {
            ((IOProcessorAware)reader).setIOProcessor(this.ioProcessor);
        }
        return reader;
    }

    public void add(NamespaceReader reader) {
        this.map.computeIfAbsent(reader.getNamespaceUri(), n -> new HashMap()).put(reader.getElementName(), reader);
    }

    public void setIOProcessor(IOProcessor ioProcessor) {
        this.ioProcessor = ioProcessor;
    }
}

