/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.config.register.storage.Node;
import net.n2oapp.framework.config.register.storage.PathUtil;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FileSystemUtil {
    private static final ResourceLoader DEFAULT_RESOURCE_LOADER = new DefaultResourceLoader();
    public static final Predicate<String> FILE_NAME_WITHOUT_DOTS = s -> {
        int idx = s.lastIndexOf(46);
        return !s.substring(0, idx).contains(".");
    };

    public static void saveContentToFile(InputStream content, File file) {
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can not touch file " + file.getAbsolutePath(), e);
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int b;
            while ((b = content.read()) != -1) {
                bos.write(b);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can not save content into file " + file.getAbsolutePath(), e);
        }
    }

    public static void saveContentToFile(String content, File file) {
        try (InputStream inputStream = IOUtils.toInputStream((String)content, (String)"UTF-8");){
            FileSystemUtil.saveContentToFile(inputStream, file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Boolean removeContentByUri(String uri) {
        Resource resource = DEFAULT_RESOURCE_LOADER.getResource(uri);
        Boolean isDeleted = false;
        try {
            File target = resource.getFile();
            isDeleted = target.delete();
        }
        catch (IOException e) {
            throw new RuntimeException("Can not delete file " + uri, e);
        }
        return isDeleted;
    }

    public static List<Node> getNodesByLocationPattern(String locationPattern) {
        return FileSystemUtil.getNodesByLocationPattern(locationPattern, name -> true);
    }

    public static Node getNodeByClasspathUri(String uri) {
        ClassPathResource resource = new ClassPathResource(uri);
        try {
            return Node.byLocationPattern((Resource)resource, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Node> getNodesByLocationPattern(String locationPattern, Predicate<String> nameFilter) {
        PathMatchingResourcePatternResolver pathPatternResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = pathPatternResolver.getResources(locationPattern);
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Resource resource : resources) {
                if (!nameFilter.test(resource.getFilename())) continue;
                nodes.add(Node.byLocationPattern(resource, locationPattern));
            }
            return nodes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getContent(Node node) {
        return FileSystemUtil.getContentByUri(node.getURI());
    }

    public static String getContentByUri(String URI2) {
        return FileSystemUtil.getContentByUri(URI2, true);
    }

    public static String getContentByUri(String URI2, boolean isExistRequired) {
        String string;
        block8: {
            InputStream inputStream = FileSystemUtil.getContentAsStream(URI2, isExistRequired);
            try {
                String string2 = string = inputStream == null ? null : IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static InputStream getContentAsStream(String path) throws IOException {
        return FileSystemUtil.getContentAsStream(path, true);
    }

    public static InputStream getContentAsStream(String path, boolean isExistRequired) throws IOException {
        if (path == null) {
            return null;
        }
        Resource resource = DEFAULT_RESOURCE_LOADER.getResource(path);
        if (!resource.exists()) {
            if (isExistRequired) {
                throw new IllegalArgumentException("File '" + path + "' not found");
            }
            return null;
        }
        return resource.getInputStream();
    }

    public static String getContentFromResource(Resource resource) {
        String string;
        block8: {
            InputStream inputStream = resource.getInputStream();
            try {
                string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static void removeAllFromDirectory(String dir, List<String> excludePaths) throws IOException {
        File root = new File(dir);
        for (File file : root.listFiles()) {
            FileSystemUtil.deleteRecursively(file, excludePaths);
        }
    }

    public static long getFileSizeByUri(String uri) throws IOException {
        if (uri == null) {
            return 0L;
        }
        if (uri.startsWith("jar:") || uri.startsWith("classpath:")) {
            Resource resource = DEFAULT_RESOURCE_LOADER.getResource(uri);
            if (!resource.exists()) {
                throw new N2oException("File Not Found:" + uri);
            }
            return resource.contentLength();
        }
        if (uri.startsWith("file:")) {
            File file = new File(PathUtil.convertUrlToAbsolutePath(uri));
            if (!file.exists()) {
                throw new N2oException("File Not Found:" + uri);
            }
            return file.length();
        }
        return 0L;
    }

    private static void deleteRecursively(File dir, List<String> excludePaths) throws IOException {
        if (!dir.exists() || excludePaths.contains(PathUtil.normalize(dir.getAbsolutePath()))) {
            return;
        }
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                IOException exception = null;
                for (File file : files) {
                    try {
                        FileSystemUtil.deleteRecursively(file, excludePaths);
                    }
                    catch (IOException ioe) {
                        exception = ioe;
                    }
                }
                if (null != exception) {
                    throw exception;
                }
            }
            if (!(dir.listFiles() != null && dir.listFiles().length != 0 || dir.delete())) {
                throw new IOException("Unable to delete directory: " + dir);
            }
        } else if (!dir.delete()) {
            throw new IOException("Unable to delete file: " + dir);
        }
    }
}

