/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.WidgetIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractOpenPageCompiler<D extends Action, S extends N2oAbstractPageAction>
extends AbstractActionCompiler<D, S> {
    protected List<N2oPreFilter> initPreFilters(N2oAbstractPageAction source, String masterIdParam, CompileProcessor p) {
        WidgetIdAware widgetIdAware;
        ArrayList<N2oPreFilter> preFilters = new ArrayList<N2oPreFilter>();
        ReduxModel model = this.getTargetWidgetModel(p, ReduxModel.RESOLVE);
        String widgetId = this.initWidgetId(p);
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
            widgetId = widgetIdAware.getWidgetId();
        }
        if (source.getDetailFieldId() != null) {
            N2oPreFilter filter = new N2oPreFilter();
            filter.setFieldId((String)p.cast((Object)source.getDetailFieldId(), (Object)"id", new Object[0]));
            filter.setType(FilterType.eq);
            filter.setValueAttr(Placeholders.ref((String)((String)p.cast((Object)source.getMasterFieldId(), (Object)"id", new Object[0]))));
            filter.setRefWidgetId(widgetId);
            if ((source.getMasterFieldId() == null || source.getMasterFieldId().equals("id")) && ReduxModel.RESOLVE.equals((Object)model)) {
                filter.setParam((String)p.cast((Object)source.getMasterParam(), (Object)masterIdParam, new Object[]{this.createGlobalParam(filter.getFieldId(), p)}));
            } else {
                filter.setParam((String)p.cast((Object)source.getMasterParam(), (Object)this.createGlobalParam(filter.getFieldId(), p), new Object[0]));
            }
            filter.setRefModel(ReduxModel.RESOLVE);
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            if (pageScope != null) {
                filter.setRefPageId(pageScope.getPageId());
            }
            preFilters.add(filter);
        }
        if (source.getPreFilters() != null) {
            for (N2oPreFilter preFilter : source.getPreFilters()) {
                N2oPreFilter filter = new N2oPreFilter();
                filter.setFieldId(preFilter.getFieldId());
                filter.setParam((String)p.cast((Object)preFilter.getParam(), (Object)this.createGlobalParam(filter.getFieldId(), p), new Object[0]));
                filter.setType(preFilter.getType());
                filter.setValueAttr(preFilter.getValueAttr());
                filter.setValuesAttr(preFilter.getValuesAttr());
                filter.setRefWidgetId((String)p.cast((Object)preFilter.getRefWidgetId(), (Object)widgetId, new Object[0]));
                filter.setRefModel((ReduxModel)p.cast((Object)preFilter.getRefModel(), (Object)model, new Object[0]));
                PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                if (pageScope != null) {
                    filter.setRefPageId(pageScope.getPageId());
                }
                preFilters.add(filter);
            }
        }
        return preFilters;
    }

    protected abstract PageContext constructContext(String var1, String var2);

    protected PageContext initPageContext(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
        String pageId = source.getPageId();
        ReduxModel actionDataModel = this.getTargetWidgetModel(p, ReduxModel.RESOLVE);
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String route = (String)p.cast((Object)(routeScope != null ? routeScope.getUrl() : null), (Object)context.getRoute((BindProcessor)((N2oCompileProcessor)p)), new Object[]{""});
        StrictMap pathMapping = new StrictMap();
        StrictMap queryMapping = new StrictMap();
        if (routeScope != null) {
            pathMapping.putAll(routeScope.getPathMapping());
            queryMapping.putAll(routeScope.getQueryMapping());
        }
        String currentClientWidgetId = null;
        String currentWidgetQueryId = null;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            currentClientWidgetId = widgetScope.getClientWidgetId();
            currentWidgetQueryId = widgetScope.getQueryId();
        }
        ModelLink actionModelLink = null;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null) {
            WidgetIdAware widgetIdAware = componentScope.unwrap(WidgetIdAware.class);
            String actionDataModelClientWidgetId = null;
            actionDataModelClientWidgetId = widgetIdAware != null && widgetIdAware.getWidgetId() != null ? pageScope.getGlobalWidgetId(widgetIdAware.getWidgetId()) : currentClientWidgetId;
            if (actionDataModel != null && actionDataModelClientWidgetId != null) {
                actionModelLink = currentClientWidgetId != null && currentClientWidgetId.equals(actionDataModelClientWidgetId) && ReduxModel.RESOLVE.equals((Object)actionDataModel) ? Redux.linkQuery(actionDataModelClientWidgetId, "id", currentWidgetQueryId) : new ModelLink(actionDataModel, actionDataModelClientWidgetId, "id");
            }
        }
        if (actionModelLink == null) {
            throw new N2oException("widget-id for action " + source.getId() + " not specified");
        }
        if (currentClientWidgetId == null) {
            currentClientWidgetId = actionModelLink.getWidgetId();
        }
        String actionRoute = this.initActionRoute(source, actionModelLink, p);
        String masterIdParam = this.initMasterLink(source.getPathParams(), actionRoute, (Map<String, ModelLink>)pathMapping, actionModelLink);
        this.addPathMappings(source, (Map<String, ModelLink>)pathMapping, widgetScope, pageScope, actionDataModel, p);
        route = RouteUtil.normalize(route + actionRoute);
        String parentRoute = RouteUtil.absolute("../", route);
        PageContext pageContext = this.constructContext(pageId, route);
        pageContext.setPageName(source.getPageName());
        pageContext.setBreadcrumbs((List)p.getScope(BreadcrumbList.class));
        pageContext.setSubmitOperationId(source.getSubmitOperationId());
        pageContext.setSubmitLabel(source.getSubmitLabel());
        pageContext.setSubmitModel(source.getSubmitModel());
        pageContext.setSubmitActionType(source.getSubmitActionType());
        pageContext.setCopyModel(source.getCopyModel());
        pageContext.setCopyWidgetId(source.getCopyWidgetId());
        pageContext.setCopyFieldId(source.getCopyFieldId());
        pageContext.setTargetModel(source.getTargetModel());
        pageContext.setTargetWidgetId(source.getTargetWidgetId());
        pageContext.setTargetFieldId(source.getTargetFieldId());
        pageContext.setCopyMode(source.getCopyMode());
        pageContext.setResultWidgetId(source.getResultContainerId());
        pageContext.setUpload(source.getUpload());
        pageContext.setParentWidgetId(this.initWidgetId(p));
        pageContext.setParentClientWidgetId(currentClientWidgetId);
        pageContext.setParentClientPageId(pageScope != null ? pageScope.getPageId() : null);
        pageContext.setParentModelLink(actionModelLink);
        pageContext.setParentRoute(RouteUtil.addQueryParams(parentRoute, (Map<String, ModelLink>)queryMapping));
        pageContext.setCloseOnSuccessSubmit((Boolean)p.cast((Object)source.getCloseAfterSubmit(), (Object)true, new Object[0]));
        pageContext.setRefreshOnSuccessSubmit((Boolean)p.cast((Object)source.getRefreshAfterSubmit(), (Object)true, new Object[0]));
        if (source.getRefreshWidgetId() != null && pageScope != null) {
            pageContext.setRefreshClientWidgetId(pageScope.getGlobalWidgetId(source.getRefreshWidgetId()));
        }
        pageContext.setRefreshOnClose((Boolean)p.cast((Object)source.getRefreshOnClose(), (Object)false, new Object[0]));
        pageContext.setUnsavedDataPromptOnClose(source.getUnsavedDataPromptOnClose());
        if (source.getSubmitOperationId() != null && source.getRedirectUrlAfterSubmit() == null && source.getFocusAfterSubmit() != null && source.getFocusAfterSubmit().booleanValue()) {
            pageContext.setRedirectUrlOnSuccessSubmit(routeScope != null ? RouteUtil.normalize(routeScope.getUrl() + RouteUtil.normalize(Placeholders.colon((String)"id"))) : null);
            pageContext.setRedirectTargetOnSuccessSubmit(Target.application);
        } else if (source.getRedirectUrlAfterSubmit() != null) {
            pageContext.setRedirectUrlOnSuccessSubmit(source.getRedirectUrlAfterSubmit());
            pageContext.setRedirectTargetOnSuccessSubmit((Target)p.cast((Object)source.getRedirectTargetAfterSubmit(), (Object)(RouteUtil.isApplicationUrl(source.getRedirectUrlAfterSubmit()) ? Target.application : Target.self), new Object[0]));
        }
        List<N2oPreFilter> preFilters = this.initPreFilters((N2oAbstractPageAction)source, masterIdParam, p);
        pageContext.setPreFilters(preFilters);
        pageContext.setPathRouteMapping((Map<String, ModelLink>)pathMapping);
        queryMapping.putAll(this.initPreFilterParams(preFilters, (Map<String, ModelLink>)pathMapping));
        if (source.getQueryParams() != null) {
            ArrayList<N2oParam> params = new ArrayList<N2oParam>();
            for (N2oParam param : source.getQueryParams()) {
                params.add(new N2oParam(param.getName(), param.getValue(), (String)p.cast((Object)param.getRefWidgetId(), (Object)(widgetScope == null ? null : widgetScope.getWidgetId()), new Object[0]), (ReduxModel)p.cast((Object)param.getRefModel(), (Object)actionDataModel, new Object[0]), pageScope == null ? null : pageScope.getPageId()));
            }
            queryMapping.putAll(this.initParams(params, (Map<String, ModelLink>)pathMapping));
        }
        pageContext.setQueryRouteMapping((Map<String, ModelLink>)queryMapping);
        this.initPageRoute(compiled, route, (Map<String, ModelLink>)pathMapping, (Map<String, ModelLink>)queryMapping);
        this.initOtherPageRoute(p, context, route);
        p.addRoute((CompileContext)pageContext);
        return pageContext;
    }

    private String initMasterLink(N2oParam[] pathParams, String actionRoute, Map<String, ModelLink> pathMapping, ModelLink actionModelLink) {
        List<String> actionRouteParams = RouteUtil.getParams(actionRoute);
        String masterIdParam = null;
        if (!actionRouteParams.isEmpty()) {
            masterIdParam = actionRouteParams.get(0);
            if (pathParams != null) {
                String finalMasterIdParam = masterIdParam;
                Optional<N2oParam> pathParam = Arrays.stream(pathParams).filter(p -> finalMasterIdParam.equals(p.getName())).findFirst();
                if (pathParam.isPresent()) {
                    String value = pathParam.get().getValue();
                    actionModelLink = StringUtils.isLink((Object)value) ? new ModelLink(actionModelLink.getModel(), actionModelLink.getWidgetId(), value.substring(1, value.length() - 1)) : new ModelLink((Object)value);
                }
            }
            pathMapping.put(masterIdParam, actionModelLink);
        }
        return masterIdParam;
    }

    private void addPathMappings(S source, Map<String, ModelLink> pathMapping, WidgetScope widgetScope, PageScope pageScope, ReduxModel actionDataModel, CompileProcessor p) {
        if (source.getPathParams() != null) {
            ArrayList<N2oParam> params = new ArrayList<N2oParam>();
            for (N2oParam param : source.getPathParams()) {
                params.add(new N2oParam(param.getName(), param.getValue(), (String)p.cast((Object)param.getRefWidgetId(), (Object)(widgetScope == null ? null : widgetScope.getWidgetId()), new Object[0]), (ReduxModel)p.cast((Object)param.getRefModel(), (Object)actionDataModel, new Object[0]), pageScope == null ? null : pageScope.getPageId()));
            }
            pathMapping.putAll(this.initParams(params, pathMapping));
        }
    }

    private String initActionRoute(S source, ModelLink actionModelLink, CompileProcessor p) {
        String actionRoute = source.getRoute();
        if (actionRoute == null) {
            actionRoute = RouteUtil.normalize(source.getId());
            if (actionModelLink != null && ReduxModel.RESOLVE.equals((Object)actionModelLink.getModel())) {
                String masterIdParam = source.getMasterFieldId() == null || "id".equalsIgnoreCase(source.getMasterFieldId()) ? (String)p.cast((Object)source.getMasterParam(), (Object)(actionModelLink.getWidgetId() + "_id"), new Object[0]) : "id";
                actionRoute = RouteUtil.normalize(Placeholders.colon((String)masterIdParam)) + actionRoute;
            }
        }
        return actionRoute;
    }

    protected abstract void initPageRoute(D var1, String var2, Map<String, ModelLink> var3, Map<String, ModelLink> var4);

    private void initOtherPageRoute(CompileProcessor p, CompileContext<?, ?> context, String route) {
        if (context instanceof ModalPageContext) {
            return;
        }
        PageRoutes pageRoutes = (PageRoutes)p.getScope(PageRoutes.class);
        if (pageRoutes != null) {
            PageRoutes.Route pageRoute = new PageRoutes.Route(route);
            pageRoute.setIsOtherPage(Boolean.valueOf(true));
            pageRoutes.addRoute(pageRoute);
        }
    }

    private Map<String, ModelLink> initPreFilterParams(List<N2oPreFilter> preFilters, Map<String, ModelLink> pathParams) {
        return preFilters == null ? null : preFilters.stream().filter(f -> f.getParam() != null && !pathParams.keySet().contains(f.getParam())).collect(Collectors.toMap(N2oPreFilter::getParam, Redux::linkParam));
    }

    private Map<String, ModelLink> initParams(List<N2oParam> params, Map<String, ModelLink> pathParams) {
        return params == null ? null : params.stream().filter(f -> f.getName() != null && !pathParams.keySet().contains(f.getName())).collect(Collectors.toMap(N2oParam::getName, Redux::linkParam));
    }

    private String createGlobalParam(String param, CompileProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope == null || widgetScope.getClientWidgetId() == null) {
            return param;
        }
        return widgetScope.getClientWidgetId() + "_" + param;
    }

    private String initWidgetId(CompileProcessor p) {
        WidgetIdAware widgetIdAware;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getWidgetId();
        }
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
            return widgetIdAware.getWidgetId();
        }
        return null;
    }
}

