/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.control.plain.N2oAutoComplete;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.control.AutoComplete;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import org.springframework.stereotype.Component;

@Component
public class AutoCompleteCompiler
extends StandardFieldCompiler<AutoComplete, N2oAutoComplete> {
    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.auto_complete.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oAutoComplete.class;
    }

    public StandardField<AutoComplete> compile(N2oAutoComplete source, CompileContext<?, ?> context, CompileProcessor p) {
        AutoComplete autoComplete = new AutoComplete();
        autoComplete.setValueFieldId((String)p.cast((Object)source.getValueFieldId(), (Object)"name", new Object[0]));
        if (source.getQueryId() != null) {
            autoComplete.setDataProvider(this.compileDataProvider(source, context, p));
        } else if (source.getOptions() != null) {
            ArrayList<DataSet> list = new ArrayList<DataSet>();
            for (Map option : source.getOptions()) {
                DataSet dataItem = new DataSet();
                option.forEach((f, v) -> dataItem.put(f, p.resolve(v)));
                list.add(dataItem);
            }
            autoComplete.setData(list);
        }
        return this.compileStandardField(autoComplete, source, context, p);
    }

    private ClientDataProvider compileDataProvider(N2oAutoComplete source, CompileContext<?, ?> context, CompileProcessor p) {
        QueryContext queryContext = new QueryContext(source.getQueryId());
        ModelsScope modelsScope = (ModelsScope)p.getScope(ModelsScope.class);
        queryContext.setFailAlertWidgetId(modelsScope != null ? modelsScope.getWidgetId() : null);
        CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)queryContext);
        String route = query.getRoute();
        p.addRoute((CompileContext)new QueryContext(source.getQueryId(), route));
        N2oClientDataProvider dataProvider = new N2oClientDataProvider();
        dataProvider.setUrl(route);
        dataProvider.setQuickSearchParam((String)p.cast((Object)source.getSearchFilterId(), (Object)"name", new Object[0]));
        return ClientDataProviderUtil.compile(dataProvider, context, p);
    }
}

