/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oStandardField;
import net.n2oapp.framework.api.metadata.control.Submit;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.control.Control;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class StandardFieldCompiler<D extends Control, S extends N2oStandardField>
extends FieldCompiler<StandardField<D>, S> {
    protected StandardField<D> compileStandardField(D control, S source, CompileContext<?, ?> context, CompileProcessor p) {
        StandardField field = new StandardField();
        if (control.getSrc() == null) {
            control.setSrc(source.getSrc());
        }
        source.setSrc(null);
        this.compileField(field, source, context, p);
        field.setClassName(null);
        this.initValidations(source, (Field)field, context, p);
        this.compileFilters(source, p);
        this.compileCopied(source, p);
        this.compileControl(control, source, p, field);
        field.setControl(control);
        field.setDataProvider(this.initDataProvider(source, context, p));
        return field;
    }

    protected void compileControl(D control, S source, CompileProcessor p, StandardField<D> field) {
        control.setSrc((String)p.cast((Object)control.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)this.getControlSrcProperty()), String.class)), new Object[0]));
        if (control.getSrc() == null) {
            throw new N2oException("control src is required");
        }
        control.setId(source.getId());
        control.setClassName(p.resolveJS(source.getCssClass()));
        control.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        this.compileDefaultValues(field, source, p);
    }

    @Override
    protected String initLabel(S source, CompileProcessor p) {
        if (source.getNoLabel() == null || !source.getNoLabel().booleanValue()) {
            String label = super.initLabel(source, p);
            FieldSetScope scope = (FieldSetScope)p.getScope(FieldSetScope.class);
            if (label == null && scope != null) {
                label = (String)scope.get(source.getId());
            }
            if (label == null) {
                label = source.getId();
            }
            return label;
        }
        return null;
    }

    protected abstract String getControlSrcProperty();

    private ClientDataProvider initDataProvider(S source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getSubmit() == null) {
            return null;
        }
        N2oClientDataProvider dataProvider = new N2oClientDataProvider();
        Submit submit = source.getSubmit();
        dataProvider.setMethod(RequestMethod.POST);
        dataProvider.setUrl(submit.getRoute());
        dataProvider.setSubmitForm(Boolean.valueOf(false));
        dataProvider.setTargetModel(ReduxModel.RESOLVE);
        dataProvider.setPathParams(submit.getPathParams());
        dataProvider.setHeaderParams(submit.getHeaderParams());
        dataProvider.setFormParams(submit.getFormParams());
        CompiledObject compiledObject = (CompiledObject)p.getScope(CompiledObject.class);
        if (compiledObject == null) {
            throw new N2oException("For compilation submit for field [{0}] is necessary object!").addData(new Object[]{source.getId()});
        }
        N2oClientDataProvider.ActionContextData actionContextData = new N2oClientDataProvider.ActionContextData();
        actionContextData.setObjectId(compiledObject.getId());
        actionContextData.setOperationId(submit.getOperationId());
        actionContextData.setRoute(submit.getRoute());
        actionContextData.setMessageOnSuccess(((Boolean)p.cast((Object)submit.getMessageOnSuccess(), (Object)false, new Object[0])).booleanValue());
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            actionContextData.setSuccessAlertWidgetId(widgetScope.getWidgetId());
            actionContextData.setFailAlertWidgetId(widgetScope.getWidgetId());
        }
        actionContextData.setMessageOnFail(((Boolean)p.cast((Object)submit.getMessageOnFail(), (Object)false, new Object[0])).booleanValue());
        actionContextData.setOperation((CompiledObject.Operation)compiledObject.getOperations().get(submit.getOperationId()));
        dataProvider.setActionContextData(actionContextData);
        return ClientDataProviderUtil.compile(dataProvider, context, p);
    }
}

