/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.N2oLeftRightPage;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.BasePageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import org.springframework.stereotype.Component;

@Component
public class LeftRightPageCompiler
extends BasePageCompiler<N2oLeftRightPage, StandardPage> {
    public StandardPage compile(N2oLeftRightPage source, PageContext context, CompileProcessor p) {
        StandardPage page = new StandardPage();
        ArrayList<N2oRegion> allRegions = new ArrayList<N2oRegion>();
        allRegions.addAll(Arrays.asList(source.getLeft()));
        allRegions.addAll(Arrays.asList(source.getRight()));
        if (source.getLeftWidth() != null && !source.getLeftWidth().isEmpty() || source.getRightWidth() != null && !source.getRightWidth().isEmpty()) {
            StandardPage standardPage = page;
            Objects.requireNonNull(standardPage);
            page.setWidth(new StandardPage.RegionWidth(standardPage, source.getLeftWidth(), source.getRightWidth()));
        }
        return this.compilePage(source, page, context, p, allRegions.toArray(new N2oRegion[0]), null);
    }

    @Override
    protected void initRegions(N2oLeftRightPage source, StandardPage page, CompileProcessor p, PageContext context, PageScope pageScope, PageRoutes pageRoutes) {
        HashMap<String, List<Region>> regionMap = new HashMap<String, List<Region>>();
        IndexScope index = new IndexScope();
        this.mapRegion(source.getRight(), "right", regionMap, p, context, pageScope, index, pageRoutes);
        this.mapRegion(source.getLeft(), "left", regionMap, p, context, pageScope, index, pageRoutes);
        page.setRegions(regionMap);
    }

    public Class<? extends Source> getSourceClass() {
        return N2oLeftRightPage.class;
    }

    private void mapRegion(N2oRegion[] regions, String position, Map<String, List<Region>> regionMap, CompileProcessor p, PageContext context, Object ... scopes) {
        if (regions != null) {
            ArrayList<Region> regionList = new ArrayList<Region>();
            for (N2oRegion n2oRegion : regions) {
                Region region = (Region)p.compile((Object)n2oRegion, (CompileContext)context, scopes);
                regionList.add(region);
            }
            regionMap.put(position, regionList);
        }
    }

    @Override
    protected String getPropertyPageSrc() {
        return "n2o.api.page.left_right.src";
    }
}

