/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.region;

import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.region.N2oPanelRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.region.PanelRegion;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.region.BaseRegionCompiler;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class PanelRegionCompiler
extends BaseRegionCompiler<PanelRegion, N2oPanelRegion> {
    @Override
    protected String getPropertyRegionSrc() {
        return "n2o.api.region.panel.src";
    }

    public Class<N2oPanelRegion> getSourceClass() {
        return N2oPanelRegion.class;
    }

    public PanelRegion compile(N2oPanelRegion source, PageContext context, CompileProcessor p) {
        PanelRegion region = new PanelRegion();
        this.build(region, source, p);
        region.setPlace(source.getPlace());
        region.setClassName(source.getClassName());
        region.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        region.setItems(this.initItems((N2oRegion)source, p, PanelRegion.Panel.class));
        region.setColor(source.getColor());
        region.setIcon(source.getIcon());
        if (region.getItems() != null && !region.getItems().isEmpty()) {
            region.setHasTabs(Boolean.valueOf(region.getItems().size() > 1));
        }
        region.setHeader(source.getHeader());
        region.setFooterTitle(source.getFooterTitle());
        region.setOpen((Boolean)p.cast((Object)source.getOpen(), (Object)true, new Object[0]));
        region.setCollapsible(Boolean.valueOf(source.getCollapsible() != null ? source.getCollapsible() : true));
        region.setFullScreen(Boolean.valueOf(false));
        this.compilePanelRoute(source, region.getId(), p);
        if (source.getTitle() == null && region.getItems().size() == 1) {
            region.setHeaderTitle(((Region.Item)region.getItems().get(0)).getLabel());
        } else {
            region.setHeaderTitle(source.getTitle());
        }
        return region;
    }

    private void compilePanelRoute(N2oPanelRegion source, String regionId, CompileProcessor p) {
        String activeParam = (String)p.cast((Object)source.getActiveParam(), (Object)regionId, new Object[0]);
        Boolean routable = (Boolean)p.cast((Object)source.getRoutable(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.region.panel.routable"), Boolean.class)), new Object[0]);
        PageRoutes routes = (PageRoutes)p.getScope(PageRoutes.class);
        if (routes == null || !Boolean.TRUE.equals(routable)) {
            return;
        }
        routes.addQueryMapping(activeParam, Redux.dispatchSetActiveRegionEntity(regionId, activeParam), Redux.createActiveRegionEntityLink(regionId));
    }

    @Override
    protected String createId(String regionPlace, CompileProcessor p) {
        return this.createId(regionPlace, "panel", p);
    }

    protected PanelRegion.Panel createItem(N2oWidget widget, IndexScope index, CompileProcessor p) {
        PanelRegion.Panel panel = new PanelRegion.Panel();
        panel.setIcon(widget.getIcon());
        panel.setLabel(widget.getName());
        panel.setId("panel" + index.get());
        panel.setOpened((Boolean)p.cast((Object)widget.getOpened(), (Object)true, new Object[0]));
        panel.setProperties(p.mapAttributes((ExtensionAttributesAware)widget));
        return panel;
    }
}

