/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.Collections;
import java.util.List;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.ButtonGenerator;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.event.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.event.action.N2oShowModal;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.config.metadata.compile.action.DefaultActions;

public abstract class AbstractButtonGenerator
implements ButtonGenerator {
    protected List<ToolbarItem> build(DefaultActions action, CompileProcessor p) {
        N2oButton button = new N2oButton();
        button.setId(action.name());
        button.setLabel(p.getMessage(action.getLabel(), new Object[0]));
        button.setIcon(action.getIcon());
        button.setKey(action.getHotKey());
        button.setDefaultAction(Boolean.valueOf(action.isDefaultAction()));
        button.setReadonly(Boolean.valueOf(false));
        if (action.isContext()) {
            button.setModel(ReduxModel.RESOLVE);
        } else {
            button.setModel(ReduxModel.FILTER);
        }
        switch (action) {
            case delete: {
                N2oInvokeAction invokeAction = new N2oInvokeAction();
                invokeAction.setOperationId(action.name());
                button.setConfirm(Boolean.valueOf(true));
                button.setAction((N2oAction)invokeAction);
                break;
            }
            case create: {
                N2oShowModal modal = new N2oShowModal();
                CompiledObject object = (CompiledObject)p.getScope(CompiledObject.class);
                modal.setPageId(object.getId());
                modal.setObjectId(object.getId());
                modal.setPageName(p.getMessage(action.getPageName(), new Object[]{object.getName()}));
                modal.setSubmitOperationId(action.name());
                modal.setUpload(action.getUpload());
                modal.setFocusAfterSubmit(Boolean.valueOf(true));
                modal.setCloseAfterSubmit(Boolean.valueOf(true));
                button.setAction((N2oAction)modal);
                break;
            }
            case update: {
                N2oShowModal modal = new N2oShowModal();
                CompiledObject object = (CompiledObject)p.getScope(CompiledObject.class);
                modal.setPageId(object.getId());
                modal.setObjectId(object.getId());
                modal.setPageName(p.getMessage(action.getPageName(), new Object[]{object.getName()}));
                modal.setMasterFieldId("id");
                modal.setDetailFieldId("id");
                modal.setSubmitOperationId(action.name());
                modal.setUpload(action.getUpload());
                modal.setFocusAfterSubmit(Boolean.valueOf(true));
                modal.setCloseAfterSubmit(Boolean.valueOf(true));
                button.setAction((N2oAction)modal);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return Collections.singletonList(button);
    }
}

