/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.AbstractMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.meta.action.LinkAction;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.MenuItem;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.PerformButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Submenu;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.BaseButtonCompiler;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class SubmenuCompiler
extends BaseButtonCompiler<N2oSubmenu, Submenu>
implements MetadataEnvironmentAware {
    protected ButtonGeneratorFactory buttonGeneratorFactory;

    public void setEnvironment(MetadataEnvironment environment) {
        this.buttonGeneratorFactory = environment.getButtonGeneratorFactory();
    }

    public Class<? extends Source> getSourceClass() {
        return N2oSubmenu.class;
    }

    public Submenu compile(N2oSubmenu sub, CompileContext<?, ?> context, CompileProcessor p) {
        Submenu button = new Submenu();
        button.setSrc((String)p.cast((Object)sub.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.action.submenu.src"), String.class)), new Object[0]));
        IndexScope idx = (IndexScope)p.getScope(IndexScope.class);
        button.setId(sub.getId() == null ? "subMenu" + idx.get() : sub.getId());
        button.setLabel(sub.getLabel());
        button.setClassName(sub.getClassName());
        button.setStyle(StylesResolver.resolveStyles(sub.getStyle()));
        if (sub.getColor() == null) {
            N2oCell component;
            ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
            if (componentScope != null && (component = componentScope.unwrap(N2oCell.class)) != null) {
                button.setColor((String)p.resolve(Placeholders.property((String)"n2o.api.cell.toolbar.button-color"), String.class));
            }
        } else {
            button.setColor(sub.getColor());
        }
        if (sub.getDescription() != null) {
            button.setHint(sub.getDescription().trim());
        }
        button.setIcon(sub.getIcon());
        button.setVisible((Object)sub.getVisible());
        if (sub.getMenuItems() != null) {
            button.setSubMenu(Stream.of(sub.getMenuItems()).map(mi -> {
                PerformButton menuItem = new PerformButton();
                menuItem.setSrc((String)p.resolve(Placeholders.property((String)"n2o.api.action.button.src"), String.class));
                this.initItem((MenuItem)menuItem, (AbstractMenuItem)mi, idx, context, p);
                if (menuItem.getAction() instanceof LinkAction) {
                    LinkAction linkAction = (LinkAction)menuItem.getAction();
                    menuItem.setUrl(linkAction.getUrl());
                    menuItem.setTarget(linkAction.getTarget());
                    menuItem.setPathMapping(linkAction.getPathMapping());
                    menuItem.setQueryMapping(linkAction.getQueryMapping());
                }
                return menuItem;
            }).collect(Collectors.toList()));
        }
        if (sub.getGenerate() != null) {
            if (button.getSubMenu() == null) {
                button.setSubMenu(new ArrayList());
            }
            for (String generate : sub.getGenerate()) {
                N2oToolbar source = (N2oToolbar)p.getScope(N2oToolbar.class);
                for (ToolbarItem toolbarItem : this.buttonGeneratorFactory.generate(generate.trim(), source, context, p)) {
                    MenuItem menuItem = new MenuItem();
                    menuItem.setSrc((String)p.resolve(Placeholders.property((String)"n2o.api.action.button.src"), String.class));
                    button.getSubMenu().add(menuItem);
                    this.initItem(menuItem, (AbstractMenuItem)((N2oButton)toolbarItem), idx, context, p);
                }
            }
        }
        return button;
    }
}

