/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.HashMap;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.list.N2oListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oAbstractCell;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.widget.ListWidget;
import net.n2oapp.framework.api.metadata.meta.widget.Rows;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.widget.BaseListWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class ListWidgetCompiler
extends BaseListWidgetCompiler<ListWidget, N2oListWidget> {
    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.list.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oListWidget.class;
    }

    public ListWidget compile(N2oListWidget source, CompileContext<?, ?> context, CompileProcessor p) {
        ListWidget listWidget = new ListWidget();
        CompiledObject object = this.getObject(source, p);
        this.compileWidget(listWidget, source, context, p, object);
        ParentRouteScope widgetRoute = this.initWidgetRouteScope(listWidget, context, p);
        PageRoutesScope pageRoutesScope = (PageRoutesScope)p.getScope(PageRoutesScope.class);
        if (pageRoutesScope != null) {
            pageRoutesScope.put(listWidget.getId(), widgetRoute);
        }
        this.compileDataProviderAndRoutes(listWidget, source, context, p, null, widgetRoute, null, null, object);
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setWidgetId(source.getId());
        widgetScope.setQueryId(source.getQueryId());
        widgetScope.setClientWidgetId(listWidget.getId());
        MetaActions widgetActions = new MetaActions();
        this.compileToolbarAndAction(listWidget, source, context, p, widgetScope, widgetRoute, widgetActions, object, null);
        this.compileList(source, listWidget, context, widgetActions, p, widgetScope, widgetRoute, widgetActions, object);
        if (source.getRows() != null) {
            listWidget.setRows(new Rows());
            listWidget.setRowClick(this.compileRowClick((N2oAbstractListWidget)source, context, p, widgetScope, widgetRoute, object, widgetActions));
        }
        listWidget.setPaging(this.compilePaging((N2oAbstractListWidget)source, (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.list.size"), Integer.class)));
        return listWidget;
    }

    private void compileList(N2oListWidget source, ListWidget compiled, CompileContext<?, ?> context, MetaActions actions, CompileProcessor p, WidgetScope widgetScope, ParentRouteScope widgetRoute, MetaActions widgetActions, CompiledObject object) {
        if (source.getContent() == null) {
            return;
        }
        HashMap<String, N2oAbstractCell> list = new HashMap<String, N2oAbstractCell>();
        for (N2oListWidget.ContentElement element : source.getContent()) {
            element.setId(element.getTextFieldId());
            if (element.getCell() == null) continue;
            list.put(element.getPlace(), (N2oAbstractCell)p.compile((Object)element.getCell(), context, new Object[]{new ComponentScope(element), actions, widgetScope, widgetRoute, widgetActions, object, new IndexScope()}));
        }
        compiled.setList(list);
    }
}

