/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.query;

import java.util.HashSet;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import org.springframework.stereotype.Component;

@Component
public class QueryValidator
implements SourceValidator<N2oQuery>,
SourceClassAware {
    public void validate(N2oQuery n2oQuery, ValidateProcessor p) {
        if (n2oQuery.getObjectId() != null) {
            p.checkForExists(n2oQuery.getObjectId(), N2oObject.class, "\u0412\u044b\u0431\u043e\u0440\u043a\u0430 '%s' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0435 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 {0}");
        }
        if (n2oQuery.getFields() != null) {
            p.checkIdsUnique((IdAware[])n2oQuery.getFields(), "\u041f\u043e\u043b\u0435 {0} \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 " + n2oQuery.getId() + "!");
        }
        if (n2oQuery.getFields() != null) {
            HashSet<String> filterFields = new HashSet<String>();
            for (N2oQuery.Field field : n2oQuery.getFields()) {
                if (field.isSearchUnavailable() || field.getFilterList() == null) continue;
                for (N2oQuery.Filter filter : field.getFilterList()) {
                    if (filter.getFilterField() == null || filterFields.add(filter.getFilterField())) continue;
                    throw new N2oMetadataValidationException("filter-field " + filter.getFilterField() + " in query " + n2oQuery.getId() + " is repeated");
                }
            }
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oQuery.class;
    }
}

