/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.properties;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.env.PropertyResolver;

public class MultivaluedPropertyResolver
implements PropertyResolver {
    private List<PropertyResolver> stack;

    public MultivaluedPropertyResolver(PropertyResolver ... properties) {
        if (properties == null || properties.length == 0) {
            throw new IllegalArgumentException("Must be property resolver");
        }
        this.stack = Arrays.asList(properties);
    }

    public boolean containsProperty(String key) {
        return false;
    }

    public String getProperty(String key) {
        return this.resolveStack(r -> r.getProperty(key));
    }

    public String getProperty(String key, String defaultValue) {
        return this.resolveStack(r -> r.getProperty(key), r -> r.getProperty(key, defaultValue));
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        return (T)this.resolveStack(r -> r.getProperty(key, targetType));
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)this.resolveStack(r -> r.getProperty(key, targetType), r -> r.getProperty(key, targetType, defaultValue));
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.resolveStack(r -> r.getProperty(key), r -> r.getRequiredProperty(key));
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return (T)this.resolveStack(r -> r.getProperty(key, targetType), r -> r.getRequiredProperty(key, targetType));
    }

    public String resolvePlaceholders(String text) {
        return this.resolvePlaceholdersStack(text, PropertyResolver::resolvePlaceholders, PropertyResolver::resolvePlaceholders, t -> !t.contains("${"));
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.resolvePlaceholdersStack(text, PropertyResolver::resolvePlaceholders, PropertyResolver::resolveRequiredPlaceholders, t -> !t.contains("${"));
    }

    private <T> T resolveStack(Function<PropertyResolver, T> resolver) {
        return this.resolveStack(resolver, null);
    }

    private <T> T resolveStack(Function<PropertyResolver, T> anyResolver, Function<PropertyResolver, T> lastResolver) {
        T value = null;
        for (int i = 0; i < this.stack.size() && value == null; ++i) {
            value = lastResolver != null && i == this.stack.size() - 1 ? (T)lastResolver.apply(this.stack.get(i)) : (T)anyResolver.apply(this.stack.get(i));
        }
        return value;
    }

    private String resolvePlaceholdersStack(String text, BiFunction<PropertyResolver, String, String> anyProcessor, BiFunction<PropertyResolver, String, String> lastProcessor, Predicate<String> condition) {
        if (text == null) {
            return null;
        }
        String result = text;
        for (int i = 0; i < this.stack.size() && !condition.test(result); ++i) {
            result = lastProcessor != null && i == this.stack.size() - 1 ? lastProcessor.apply(this.stack.get(i), result) : anyProcessor.apply(this.stack.get(i), result);
        }
        return result;
    }
}

