/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.tools;

import net.n2oapp.framework.api.metadata.control.N2oControlActionLink;
import net.n2oapp.framework.api.metadata.control.N2oFieldCondition;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.reader.tools.ConditionReaderV1;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class ControlActionReaderV1<T extends N2oControlActionLink>
implements TypedElementReader<T> {
    private NamespaceReaderFactory readerFactory;
    public static final Namespace DEFAULT_EVENT_NAMESPACE_URI = Namespace.getNamespace((String)"http://n2oapp.net/framework/config/schema/n2o-event-1.0");

    public void setReaderFactory(NamespaceReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
    }

    public T read(Element element) {
        if (element == null) {
            return null;
        }
        T t = this.readControlAction(element, element.getNamespace());
        this.read(t, element, element.getNamespace());
        return t;
    }

    protected abstract T readControlAction(Element var1, Namespace var2);

    protected T read(T t, Element element, Namespace namespace) {
        t.setId(ReaderJdomUtil.getAttributeString(element, "id"));
        t.setLabel(ReaderJdomUtil.getAttributeString(element, "label"));
        t.setKey(ReaderJdomUtil.getAttributeString(element, "key"));
        if (element.getChildren() != null && !element.getChildren().isEmpty()) {
            element.getChildren().forEach(elem -> {
                if (elem.getName().equals("dependencies")) {
                    t.setVisibilityCondition((N2oFieldCondition)ReaderJdomUtil.getChild(elem, "visibility-condition", ConditionReaderV1.getInstance()));
                    t.setEnablingCondition((N2oFieldCondition)ReaderJdomUtil.getChild(elem, "enabling-condition", ConditionReaderV1.getInstance()));
                } else {
                    Element eventElement = elem;
                    if (eventElement != null) {
                        N2oAction event = (N2oAction)this.readerFactory.produce(eventElement, element.getNamespace(), new Namespace[]{DEFAULT_EVENT_NAMESPACE_URI}).read(eventElement);
                        t.setEvent(event);
                    }
                }
            });
        }
        return t;
    }
}

