/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.widget;

import java.util.HashMap;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom2.Element;

public class SwitchReader
implements TypedElementReader<N2oSwitch> {
    private String switchValueAttributeName;

    public SwitchReader(String switchValueAttributeName) {
        this.switchValueAttributeName = switchValueAttributeName;
    }

    public SwitchReader() {
    }

    public N2oSwitch read(Element element) {
        Element switchEl = element.getChild("switch", element.getNamespace());
        N2oSwitch res = new N2oSwitch();
        if (switchEl != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Object el : switchEl.getChildren("case", element.getNamespace())) {
                Element e = (Element)el;
                map.put(ReaderJdomUtil.getAttributeString(e, "value"), e.getValue());
            }
            res.setCases(map);
            res.setDefaultCase(ReaderJdomUtil.getElementString(switchEl, "default"));
            res.setValueFieldId(ReaderJdomUtil.getAttributeString(switchEl, "value-field-id"));
        }
        if (this.switchValueAttributeName != null) {
            res.setFieldId(ReaderJdomUtil.getAttributeString(element, this.switchValueAttributeName));
        }
        return res;
    }

    public Class<N2oSwitch> getElementClass() {
        return N2oSwitch.class;
    }

    public String getElementName() {
        throw new UnsupportedOperationException("SwitchReader can't be generated by factory");
    }
}

