/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.test;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.n2oapp.framework.api.StringUtils;
import org.springframework.core.env.PropertyResolver;

public class SimplePropertyResolver
implements PropertyResolver {
    private Properties properties;

    public SimplePropertyResolver(Properties properties) {
        this.properties = properties;
    }

    public boolean containsProperty(String key) {
        return this.properties.get(key) != null;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        Object value = this.properties.get(key);
        if (value instanceof String && targetType != null && !String.class.equals(targetType)) {
            String strValue = (String)value;
            if (List.class.equals(targetType)) {
                ArrayList<String> list = new ArrayList<String>();
                for (String item : strValue.split(",")) {
                    list.add(item.trim());
                }
                return (T)list;
            }
            if (Set.class.equals(targetType)) {
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (String item : strValue.split(",")) {
                    set.add(item.trim());
                }
                return (T)set;
            }
            if (Boolean.class.equals(targetType)) {
                return (T)Boolean.valueOf(strValue);
            }
            if (Integer.class.equals(targetType)) {
                return (T)Integer.valueOf(strValue);
            }
            if (Long.class.equals(targetType)) {
                return (T)Long.valueOf(strValue);
            }
            throw new UnsupportedOperationException("targetType " + targetType + " is not supported");
        }
        return (T)value;
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        Object value = this.properties.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            throw new IllegalStateException("Property " + key + " not found");
        }
        return value;
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        Object value = this.properties.get(key);
        if (value == null) {
            throw new IllegalStateException("Property " + key + " not found");
        }
        return (T)value;
    }

    public String resolvePlaceholders(String text) {
        return StringUtils.resolveProperties((String)text, this::getProperty);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return StringUtils.resolveProperties((String)text, this::getRequiredProperty);
    }

    public Object setProperty(String key, Object value) {
        return this.properties.put(key, value);
    }
}

