/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Map;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oOpenDrawer;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.open_drawer.OpenDrawer;
import net.n2oapp.framework.api.metadata.meta.action.open_drawer.OpenDrawerPayload;
import net.n2oapp.framework.config.metadata.compile.action.AbstractOpenPageCompiler;
import net.n2oapp.framework.config.metadata.compile.context.DrawerPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class OpenDrawerCompiler
extends AbstractOpenPageCompiler<OpenDrawer, N2oOpenDrawer> {
    public Class<? extends Source> getSourceClass() {
        return N2oOpenDrawer.class;
    }

    public OpenDrawer compile(N2oOpenDrawer source, CompileContext<?, ?> context, CompileProcessor p) {
        OpenDrawer showModal = new OpenDrawer();
        showModal.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.open_drawer.type"), String.class));
        showModal.setObjectId(source.getObjectId());
        showModal.setOperationId(source.getOperationId());
        showModal.setPageId(source.getPageId());
        this.compileAction(showModal, source, p);
        this.initPageContext(showModal, source, context, p);
        this.compilePayload(showModal, source, context, p);
        return showModal;
    }

    @Override
    protected PageContext constructContext(String pageId, String route) {
        DrawerPageContext modalPageContext = new DrawerPageContext(pageId, route);
        modalPageContext.setClientPageId(RouteUtil.convertPathToId(route));
        return modalPageContext;
    }

    @Override
    protected void initPageRoute(OpenDrawer compiled, String route, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping) {
        OpenDrawerPayload payload = (OpenDrawerPayload)compiled.getPayload();
        String modalPageId = RouteUtil.convertPathToId(route);
        payload.setName(modalPageId);
        payload.setPageId(modalPageId);
        payload.setPageUrl(route);
        payload.setPathMapping(pathMapping);
        payload.setQueryMapping(queryMapping);
    }

    private void compilePayload(OpenDrawer showModal, N2oOpenDrawer source, CompileContext<?, ?> context, CompileProcessor p) {
        OpenDrawerPayload payload = (OpenDrawerPayload)showModal.getPayload();
        payload.setBackdrop(source.getBackdrop());
        payload.setWidth((String)p.cast((Object)source.getWidth(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.action.open_drawer.width"), String.class)), new Object[0]));
        payload.setHeight(source.getHeight());
        payload.setPlacement((String)p.cast((Object)source.getPlacement(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.action.open_drawer.placement"), String.class)), new Object[0]));
        payload.setLevel(source.getLevel());
        payload.setBackdropClosable((Boolean)p.cast((Object)source.getBackdropClosable(), (Object)true, new Object[0]));
        payload.setClosable((Boolean)p.cast((Object)source.getClosable(), (Object)true, new Object[0]));
    }
}

