/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.cell;

import java.util.HashMap;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.AbstractColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oAbstractCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oActionCell;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class AbstractCellCompiler<D extends N2oAbstractCell, S extends N2oAbstractCell>
implements BaseSourceCompiler<D, S, CompileContext<?, ?>> {
    protected D build(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p, String defaultSrc) {
        AbstractColumn column;
        ComponentScope columnScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (columnScope != null) {
            AbstractColumn column2 = columnScope.unwrap(AbstractColumn.class);
            source.setId(column2.getId());
            compiled.setId(column2.getId());
            compiled.setFieldKey(column2.getTextFieldId());
        }
        compiled.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(defaultSrc, String.class)), new Object[0]));
        compiled.setCssClass(p.resolveJS(source.getCssClass()));
        compiled.setReactStyle(StylesResolver.resolveStyles(source.getStyle()));
        compiled.setJsonVisible(p.resolveJS(source.getVisible(), Boolean.class));
        compiled.setProperties(p.mapAttributes(source));
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (column = componentScope.unwrap(AbstractColumn.class)) != null) {
            compiled.setTooltipFieldId(column.getTooltipFieldId());
        }
        return compiled;
    }

    protected void compileAction(N2oActionCell compiled, N2oActionCell source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getActionId() != null || source.getAction() != null) {
            Action action;
            if (source.getActionId() != null) {
                MetaActions actions = (MetaActions)p.getScope(MetaActions.class);
                action = (Action)actions.get(source.getActionId());
                compiled.setActionId(source.getActionId());
            } else {
                action = (Action)p.compile((Object)source.getAction(), context, new Object[]{new ComponentScope(source)});
                compiled.setActionId(source.getAction().getId());
            }
            compiled.setCompiledAction(action);
        }
    }

    protected String compileSwitch(N2oSwitch n2oSwitch, CompileProcessor p) {
        if (n2oSwitch == null) {
            return null;
        }
        HashMap<Object, String> resolvedCases = new HashMap<Object, String>();
        if (n2oSwitch.getCases() != null) {
            for (String key : n2oSwitch.getCases().keySet()) {
                resolvedCases.put(p.resolve(key), (String)n2oSwitch.getCases().get(key));
            }
        }
        n2oSwitch.setResolvedCases(resolvedCases);
        return ScriptProcessor.buildSwitchExpression((N2oSwitch)n2oSwitch);
    }
}

