/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.config.register.route.RouteUtil;

public abstract class BaseCompileContext<D extends Compiled, S>
implements CompileContext<D, S> {
    private String sourceId;
    private Class<S> sourceClass;
    private Class<D> compiledClass;
    private String route;
    private Map<String, ModelLink> queryRouteMapping;
    private Map<String, ModelLink> pathRouteMapping;
    private ModelLink parentModelLink;

    public BaseCompileContext(String sourceId, Class<S> sourceClass, Class<D> compiledClass) {
        if (sourceId == null) {
            throw new IllegalArgumentException("SourceId must not be null");
        }
        if (sourceClass == null && compiledClass == null) {
            throw new IllegalArgumentException("SourceClass or CompiledClass must not be null");
        }
        this.sourceId = sourceId;
        this.sourceClass = sourceClass;
        this.compiledClass = compiledClass;
    }

    public BaseCompileContext(String route, String sourceId, Class<S> sourceClass, Class<D> compiledClass) {
        this(sourceId, sourceClass, compiledClass);
        if (route == null) {
            throw new IllegalArgumentException("Route must not be null");
        }
        this.route = route;
    }

    public BaseCompileContext(BaseCompileContext<D, S> context) {
        this(context.sourceId, context.sourceClass, context.compiledClass);
        this.route = context.route;
        this.setPathRouteMapping(context.pathRouteMapping);
        this.setQueryRouteMapping(context.queryRouteMapping);
        this.setParentModelLink(context.parentModelLink);
    }

    public BaseCompileContext(String route, BaseCompileContext<D, S> context) {
        this(context.sourceId, context.sourceClass, context.compiledClass);
        this.route = route;
        this.setPathRouteMapping(context.pathRouteMapping);
        this.setQueryRouteMapping(context.queryRouteMapping);
        this.setParentModelLink(context.parentModelLink);
    }

    public String getCompiledId(BindProcessor p) {
        if (this.route != null) {
            String url = this.getRoute(p);
            if (StringUtils.hasLink((String)this.sourceId) && p != null) {
                return RouteUtil.convertPathToId(url) + this.getSourceId(p);
            }
            return RouteUtil.convertPathToId(url);
        }
        if (StringUtils.hasLink((String)this.sourceId) && p != null) {
            return "$" + p.resolveText(this.sourceId, this.parentModelLink);
        }
        return "$" + this.sourceId;
    }

    public String getSourceId(BindProcessor p) {
        if (StringUtils.hasLink((String)this.sourceId)) {
            this.checkProcessor(p);
            return p.resolveText(this.sourceId, this.parentModelLink);
        }
        return this.sourceId;
    }

    public String getRoute(BindProcessor p) {
        if (StringUtils.hasLink((String)this.sourceId)) {
            this.checkProcessor(p);
            return p.resolveUrl(this.route, this.parentModelLink);
        }
        return this.route;
    }

    public DataSet getParams(String url, Map<String, String[]> queryParams) {
        DataSet data = this.route == null ? new DataSet() : this.getResultData(url, this.route);
        if (queryParams != null) {
            queryParams.forEach((k, v) -> {
                if (((String[])v).length == 1) {
                    data.put(k, (Object)v[0]);
                } else {
                    data.put(k, Arrays.asList(v));
                }
            });
        }
        return data;
    }

    public Map<String, ModelLink> getQueryRouteMapping() {
        return this.queryRouteMapping;
    }

    public void setQueryRouteMapping(Map<String, ModelLink> queryRouteMapping) {
        if (queryRouteMapping != null) {
            this.queryRouteMapping = new HashMap<String, ModelLink>();
            queryRouteMapping.forEach((k, v) -> this.queryRouteMapping.put((String)k, new ModelLink(v)));
        } else {
            this.queryRouteMapping = null;
        }
    }

    public Map<String, ModelLink> getPathRouteMapping() {
        return this.pathRouteMapping;
    }

    public void setPathRouteMapping(Map<String, ModelLink> pathRouteMapping) {
        this.pathRouteMapping = pathRouteMapping != null ? Collections.unmodifiableMap(pathRouteMapping) : null;
    }

    public ModelLink getParentModelLink() {
        return this.parentModelLink;
    }

    public void setParentModelLink(ModelLink parentModelLink) {
        this.parentModelLink = parentModelLink;
    }

    public Class<D> getCompiledClass() {
        return this.compiledClass;
    }

    public Class<S> getSourceClass() {
        return this.sourceClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceId + ")";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseCompileContext)) {
            return false;
        }
        BaseCompileContext that = (BaseCompileContext)o;
        return this.sourceId.equals(that.sourceId) && this.compiledClass.equals(that.compiledClass);
    }

    private void checkProcessor(BindProcessor p) {
        if (p == null) {
            throw new IllegalArgumentException("You try to get CompiledId for dynamic metadata without CompileProcessor!");
        }
    }

    public final int hashCode() {
        return Objects.hash(this.sourceId, this.compiledClass);
    }

    private DataSet getResultData(String url, String urlPattern) {
        DataSet data = new DataSet();
        String[] splitUrl = url.split("/");
        String[] splitPattern = urlPattern.split("/");
        for (int i = 0; i < splitUrl.length && i < splitPattern.length; ++i) {
            if (!splitPattern[i].startsWith(":")) continue;
            data.put(splitPattern[i].substring(1), (Object)splitUrl[i]);
        }
        return data;
    }
}

