/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.dataprovider;

import java.util.Collections;
import java.util.Map;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.aware.WidgetIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.context.ActionContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.CompileUtil;

public class ClientDataProviderUtil {
    public static ClientDataProvider compile(N2oClientDataProvider source, CompileContext<?, ?> context, CompileProcessor p) {
        ClientDataProvider dataProvider = new ClientDataProvider();
        String path = null;
        String targetWidget = source.getTargetWidgetId() == null ? ClientDataProviderUtil.initTargetWidget(context, p) : source.getTargetWidgetId();
        ReduxModel targetModel = ClientDataProviderUtil.initTargetWidgetModel(p, source.getTargetModel());
        if (RequestMethod.POST == source.getMethod()) {
            StrictMap pathMapping = new StrictMap();
            pathMapping.putAll(ClientDataProviderUtil.compileParams(source.getPathParams(), p, targetModel, targetWidget));
            dataProvider.setFormMapping(ClientDataProviderUtil.compileParams(source.getFormParams(), p, targetModel, targetWidget));
            dataProvider.setHeadersMapping(ClientDataProviderUtil.compileParams(source.getHeaderParams(), p, targetModel, targetWidget));
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            path = (String)p.cast((Object)(routeScope != null ? routeScope.getUrl() : null), (Object)context.getRoute((BindProcessor)((N2oCompileProcessor)p)), new Object[]{""});
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            if (widgetScope != null) {
                String clientWidgetId = widgetScope.getClientWidgetId();
                if (ReduxModel.RESOLVE.equals((Object)targetModel)) {
                    String widgetSelectedId = clientWidgetId + "_id";
                    path = RouteUtil.normalize(path + RouteUtil.normalize(Placeholders.colon((String)widgetSelectedId)));
                    pathMapping.put(widgetSelectedId, new ModelLink(targetModel, clientWidgetId, "id"));
                    if (context.getPathRouteMapping() != null) {
                        pathMapping.putAll(context.getPathRouteMapping());
                    }
                }
            }
            path = RouteUtil.normalize(path + RouteUtil.normalize((String)p.cast((Object)source.getUrl(), (Object)source.getId(), new Object[]{""})));
            dataProvider.setPathMapping((Map)pathMapping);
            dataProvider.setMethod(RequestMethod.POST);
            dataProvider.setOptimistic(source.getOptimistic());
            dataProvider.setSubmitForm(source.getSubmitForm());
            ClientDataProviderUtil.initActionContext(source, (Map<String, ModelLink>)pathMapping, (String)p.cast((Object)path, (Object)source.getUrl(), new Object[0]), p);
        }
        dataProvider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + (String)p.cast(path, (Object)source.getUrl(), new Object[0]));
        dataProvider.setQueryMapping(ClientDataProviderUtil.compileParams(source.getQueryParams(), p, targetModel, targetWidget));
        dataProvider.setQuickSearchParam(source.getQuickSearchParam());
        return dataProvider;
    }

    private static Map<String, ModelLink> compileParams(N2oParam[] params, CompileProcessor p, ReduxModel model, String targetWidgetId) {
        if (params == null) {
            return Collections.emptyMap();
        }
        StrictMap result = new StrictMap();
        for (N2oParam param : params) {
            ModelLink link;
            Object value;
            Object object = value = param.getValueList() != null ? param.getValueList() : ScriptProcessor.resolveExpression((String)param.getValue());
            if (value == null || StringUtils.isJs((Object)value)) {
                String widgetId = null;
                if (param.getRefWidgetId() != null) {
                    PageScope pageScope;
                    String pageId = param.getRefPageId();
                    if (param.getRefPageId() == null && (pageScope = (PageScope)p.getScope(PageScope.class)) != null) {
                        pageId = pageScope.getPageId();
                    }
                    widgetId = CompileUtil.generateWidgetId(pageId, param.getRefWidgetId());
                }
                link = new ModelLink((ReduxModel)p.cast((Object)param.getRefModel(), (Object)model, new Object[0]), (String)p.cast((Object)widgetId, (Object)targetWidgetId, new Object[0]));
                link.setValue(value);
            } else {
                link = new ModelLink(value);
            }
            result.put(param.getName(), link);
        }
        return result;
    }

    private static void initActionContext(N2oClientDataProvider source, Map<String, ModelLink> pathMapping, String url, CompileProcessor p) {
        if (source.getActionContextData() != null) {
            N2oClientDataProvider.ActionContextData actionContextData = source.getActionContextData();
            ActionContext actionContext = new ActionContext(actionContextData.getObjectId(), actionContextData.getOperationId(), url);
            StrictMap routePathMapping = new StrictMap();
            StrictMap routeQueryMapping = new StrictMap();
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            if (routeScope != null) {
                routePathMapping.putAll(routeScope.getPathMapping());
                routePathMapping.putAll(pathMapping);
                routeQueryMapping.putAll(routeScope.getQueryMapping());
            }
            actionContext.setPathRouteMapping((Map<String, ModelLink>)routePathMapping);
            actionContext.setQueryRouteMapping((Map<String, ModelLink>)routeQueryMapping);
            ValidationList validationList = (ValidationList)p.getScope(ValidationList.class);
            actionContext.setValidations(validationList == null ? null : validationList.get(actionContextData.getFailAlertWidgetId(), ClientDataProviderUtil.initTargetWidgetModel(p, source.getTargetModel())));
            actionContext.setRedirect(actionContextData.getRedirect());
            actionContext.setParentWidgetId(actionContextData.getParentWidgetId());
            actionContext.setFailAlertWidgetId(actionContextData.getFailAlertWidgetId());
            actionContext.setMessagesForm(actionContextData.getMessagesForm());
            actionContext.setSuccessAlertWidgetId(actionContextData.getSuccessAlertWidgetId());
            actionContext.setMessageOnSuccess(actionContextData.isMessageOnSuccess());
            actionContext.setMessageOnFail(actionContextData.isMessageOnFail());
            StrictMap operationMapping = new StrictMap();
            for (N2oObject.Parameter inParameter : actionContextData.getOperation().getInParametersMap().values()) {
                String param = (String)p.cast((Object)inParameter.getParam(), (Object)RouteUtil.normalizeParam(inParameter.getId()), new Object[0]);
                operationMapping.put(param, inParameter.getId());
            }
            actionContext.setOperationMapping((Map<String, String>)operationMapping);
            p.addRoute((CompileContext)actionContext);
        }
    }

    private static String initTargetWidget(CompileContext<?, ?> context, CompileProcessor p) {
        WidgetIdAware widgetIdAware;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        String targetWidgetId = null;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
            String string = targetWidgetId = pageScope == null ? widgetIdAware.getWidgetId() : pageScope.getGlobalWidgetId(widgetIdAware.getWidgetId());
        }
        if (targetWidgetId == null) {
            if (widgetScope != null) {
                targetWidgetId = widgetScope.getClientWidgetId();
            } else if (context instanceof PageContext && ((PageContext)context).getResultWidgetId() != null && pageScope != null) {
                targetWidgetId = pageScope.getGlobalWidgetId(((PageContext)context).getResultWidgetId());
            } else {
                throw new N2oException("Unknown widgetId for invoke action!");
            }
        }
        return targetWidgetId;
    }

    private static ReduxModel initTargetWidgetModel(CompileProcessor p, ReduxModel defaultModel) {
        ModelAware modelAware;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (modelAware = componentScope.unwrap(ModelAware.class)) != null && modelAware.getModel() != null) {
            return modelAware.getModel();
        }
        return defaultModel;
    }
}

