/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.object;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.n2oapp.framework.api.data.validation.ConditionValidation;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.MapperType;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectScalarField;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oConstraint;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.action.DefaultActions;
import net.n2oapp.framework.config.metadata.compile.context.ActionContext;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import org.springframework.stereotype.Component;

@Component
public class N2oObjectCompiler<C extends ObjectContext>
implements BaseSourceCompiler<CompiledObject, N2oObject, C> {
    public Class<N2oObject> getSourceClass() {
        return N2oObject.class;
    }

    public CompiledObject compile(N2oObject source, C context, CompileProcessor p) {
        ActionContext actionContext;
        CompiledObject compiled = new CompiledObject();
        compiled.setId(source.getId());
        compiled.setOperations((Map)new StrictMap());
        compiled.setObjectFields(new ArrayList());
        compiled.setObjectFieldsMap(new HashMap());
        if (source.getObjectFields() != null) {
            for (AbstractParameter field : source.getObjectFields()) {
                compiled.getObjectFields().add(field);
                compiled.getObjectFieldsMap().put(field.getId(), field);
                if (!(field instanceof ObjectReferenceField)) continue;
                ObjectScalarField[] referenceFields = ((ObjectReferenceField)field).getFields();
                if (referenceFields == null) {
                    ObjectScalarField innerField = new ObjectScalarField();
                    innerField.setId("id");
                    innerField.setMapping("id");
                    ((ObjectReferenceField)field).getObjectReferenceFields().add(innerField);
                    field.setNullIgnore(Boolean.valueOf(true));
                } else {
                    for (ObjectScalarField objectScalarField : referenceFields) {
                        ((ObjectReferenceField)field).getObjectReferenceFields().add(objectScalarField);
                    }
                }
                if (compiled.getObjectReferenceFieldsMap() == null) {
                    compiled.setObjectReferenceFieldsMap(new HashMap());
                }
                if (field.getId().contains(".")) {
                    field.setId(field.getId().substring(field.getId().indexOf(".") + 1, field.getId().length() - 1));
                }
                compiled.getObjectReferenceFieldsMap().put(field.getId(), (ObjectReferenceField)field);
            }
        }
        compiled.setName(CompileUtil.castDefault((String)source.getName(), (String)source.getId(), (String[])new String[0]));
        compiled.setValidationsMap(new HashMap());
        compiled.setValidations(this.initValidations(source, compiled, context, p));
        compiled.setValidationsMap(N2oObjectCompiler.initValidationsMap(compiled.getValidations()));
        this.initOperationsMap(source, compiled, context, p);
        compiled.setTableName(source.getTableName());
        compiled.setEntityClass(source.getEntityClass());
        compiled.setAppName(source.getAppName());
        compiled.setModuleName(source.getModuleName());
        compiled.setServiceClass(source.getServiceClass());
        compiled.setServiceName(source.getServiceName());
        if (context instanceof ActionContext && (actionContext = (ActionContext)context).getValidations() != null) {
            compiled.setFieldValidations(actionContext.getValidations());
        }
        return compiled;
    }

    private List<Validation> initValidations(N2oObject source, CompiledObject compiled, C context, CompileProcessor p) {
        ArrayList<Validation> result = new ArrayList<Validation>();
        if (source.getN2oValidations() != null) {
            for (N2oValidation validation : source.getN2oValidations()) {
                N2oConstraint n2oConstraint;
                if (validation instanceof N2oConstraint && (n2oConstraint = (N2oConstraint)validation).getInParameters() != null) {
                    for (N2oObject.Parameter parameter : n2oConstraint.getInParameters()) {
                        this.resolveDefaultParameter(parameter, compiled);
                        parameter.setRequired((Boolean)p.cast((Object)parameter.getRequired(), (Object)(parameter.getDefaultValue() == null ? 1 : 0), new Object[0]));
                    }
                }
                result.add((Validation)p.compile((Object)validation, context, new Object[0]));
            }
        }
        return result;
    }

    private void initOperationsMap(N2oObject source, CompiledObject compiled, C context, CompileProcessor p) {
        if (source.getOperations() != null) {
            for (N2oObject.Operation operation : source.getOperations()) {
                CompiledObject.Operation compileOperation = this.compileOperation(operation, compiled, p);
                if (operation.getInParameters() != null) {
                    for (N2oObject.Parameter parameter : operation.getInParameters()) {
                        AbstractParameter compiledParameter = (AbstractParameter)compiled.getObjectFieldsMap().get(parameter.getId());
                        if (compiledParameter == null) continue;
                        parameter.setPluralityType(compiledParameter.getPluralityType());
                        parameter.setNullIgnore((Boolean)p.cast((Object)parameter.getNullIgnore(), (Object)compiledParameter.getNullIgnore(), new Object[0]));
                        if (!(compiledParameter instanceof ObjectReferenceField)) continue;
                        ArrayList<N2oObject.Parameter> childParams = new ArrayList<N2oObject.Parameter>();
                        for (ObjectScalarField field : ((ObjectReferenceField)compiledParameter).getObjectReferenceFields()) {
                            N2oObject.Parameter childParam = new N2oObject.Parameter();
                            childParam.setId(field.getId());
                            childParam.setMapping(field.getMapping());
                            childParam.setNormalize(field.getNormalize());
                            childParam.setDomain(field.getDomain());
                            childParam.setDefaultValue(field.getDefaultValue());
                            childParams.add(childParam);
                        }
                        parameter.setEntityClass((String)p.cast((Object)parameter.getEntityClass(), (Object)((ObjectReferenceField)compiledParameter).getEntityClass(), new Object[0]));
                        parameter.setMapping((String)p.cast((Object)parameter.getMapping(), (Object)compiledParameter.getMapping(), new Object[0]));
                        parameter.setChildParams(childParams.toArray(new N2oObject.Parameter[0]));
                    }
                }
                this.addOperation(compileOperation, compiled);
                this.initOperationValidations(operation, compileOperation, source, compiled, context, p);
            }
        }
    }

    private void initOperationValidations(N2oObject.Operation operation, CompiledObject.Operation compiledOperation, N2oObject source, CompiledObject compiled, C context, CompileProcessor p) {
        ArrayList<Validation> validationList = new ArrayList<Validation>();
        ArrayList<Validation> whiteListValidationList = new ArrayList<Validation>();
        ArrayList<Validation> inlineValidations = null;
        if (compiledOperation.getValidations() != null) {
            if (compiledOperation.getValidations().getActivate() == null && compiledOperation.getValidations().getBlackList() == null && compiledOperation.getValidations().getWhiteList() == null) {
                compiledOperation.getValidations().setActivate(N2oObject.Operation.Validations.Activate.all);
            } else if (compiledOperation.getValidations().getBlackList() != null && compiledOperation.getValidations().getWhiteList() != null) {
                throw new N2oException("Whitelist is incompatible with blacklist");
            }
            if (compiledOperation.getValidations().getActivate() != null) {
                this.resolveActivate(operation, compiledOperation, source);
            }
            if (compiledOperation.getValidations().getWhiteList() != null) {
                for (String name : operation.getValidations().getWhiteList()) {
                    Validation validation = (Validation)compiled.getValidationsMap().get(name.trim());
                    if (validation.getEnabled() != null && !validation.getEnabled().booleanValue()) continue;
                    validationList.add(validation);
                    if (compiledOperation.getValidations().getActivate() == N2oObject.Operation.Validations.Activate.all) continue;
                    whiteListValidationList.add(validation);
                }
            }
            if (compiledOperation.getValidations().getBlackList() != null) {
                N2oValidation[] blackListValidationsMap = new HashMap();
                blackListValidationsMap.putAll(compiled.getValidationsMap());
                String[] stringArray = operation.getValidations().getBlackList();
                int n = stringArray.length;
                for (int name = 0; name < n; ++name) {
                    String name2 = stringArray[name];
                    blackListValidationsMap.remove(name2.trim());
                }
                validationList.addAll(blackListValidationsMap.values());
            }
            if (compiledOperation.getValidations().getInlineValidations() != null) {
                inlineValidations = new ArrayList<Validation>();
                for (N2oValidation n2oValidation : operation.getValidations().getInlineValidations()) {
                    N2oConstraint n2oConstraint;
                    if (n2oValidation.getEnabled() != null && n2oValidation.getEnabled().equals("false")) continue;
                    if (n2oValidation instanceof N2oConstraint && (n2oConstraint = (N2oConstraint)n2oValidation).getInParameters() != null) {
                        for (N2oObject.Parameter parameter : n2oConstraint.getInParameters()) {
                            this.resolveDefaultParameter(parameter, compiled);
                            parameter.setRequired((Boolean)p.cast((Object)parameter.getRequired(), (Object)(parameter.getDefaultValue() == null ? 1 : 0), new Object[0]));
                        }
                    }
                    inlineValidations.add((Validation)p.compile((Object)n2oValidation, context, new Object[0]));
                }
            }
            if (inlineValidations != null) {
                validationList.addAll(inlineValidations);
                whiteListValidationList.addAll(inlineValidations);
            }
            if (validationList.size() == 0) {
                compiledOperation.setAuto(Boolean.valueOf(true));
            }
            compiledOperation.setValidationList(validationList);
            compiledOperation.setValidationsMap(N2oObjectCompiler.initValidationsMap(validationList));
            compiledOperation.setWhiteListValidationsMap(N2oObjectCompiler.initValidationsMap(whiteListValidationList));
            ArrayList<ConditionValidation> conditionList = new ArrayList<ConditionValidation>();
            for (Validation validation : validationList) {
                if (!(validation instanceof ConditionValidation)) continue;
                conditionList.add((ConditionValidation)validation);
            }
            compiledOperation.setConditionList(conditionList);
        }
        ArrayList<MandatoryValidation> requiredParamValidations = new ArrayList<MandatoryValidation>();
        for (N2oObject.Parameter parameter : compiledOperation.getInParametersMap().values()) {
            if (parameter.getRequired() == null || !parameter.getRequired().booleanValue()) continue;
            MandatoryValidation validation = new MandatoryValidation(parameter.getId(), p.getMessage("n2o.required.field", new Object[0]), parameter.getId());
            validation.setMoment(N2oValidation.ServerMoment.beforeOperation);
            requiredParamValidations.add(validation);
        }
        if (requiredParamValidations.size() > 0) {
            if (compiledOperation.getValidationList() == null) {
                compiledOperation.setValidationList(new ArrayList());
            }
            compiledOperation.getValidationList().addAll(requiredParamValidations);
        }
        if (context instanceof ActionContext && ((ActionContext)context).getValidations() != null) {
            if (compiledOperation.getValidationList() == null) {
                compiledOperation.setValidationList(new ArrayList());
            }
            this.mergeValidations(compiledOperation.getValidationList(), ((ActionContext)context).getValidations());
        }
    }

    private void mergeValidations(List<Validation> operationValidations, List<Validation> controlValidations) {
        for (Validation cv : controlValidations) {
            operationValidations.removeIf(validation -> validation.getId().equals(cv.getId()));
            operationValidations.add(cv);
        }
    }

    private void resolveActivate(N2oObject.Operation operation, CompiledObject.Operation compiledOperation, N2oObject source) {
        int i = 0;
        switch (compiledOperation.getValidations().getActivate()) {
            case all: {
                if (compiledOperation.getValidations().getWhiteList() != null || compiledOperation.getValidations().getBlackList() != null || source.getN2oValidations() == null) break;
                Integer length = source.getN2oValidations().length;
                String[] whiteList = new String[length.intValue()];
                i = 0;
                for (N2oValidation n2oValidation : source.getN2oValidations()) {
                    whiteList[i] = n2oValidation.getId();
                    ++i;
                }
                compiledOperation.getValidations().setWhiteList(whiteList);
                break;
            }
            case whiteList: {
                Integer length = operation.getValidations().getRefValidations().length;
                String[] whiteList = new String[length.intValue()];
                for (N2oObject.Operation.Validations.Validation validation : operation.getValidations().getRefValidations()) {
                    whiteList[i] = validation.getRefId();
                    ++i;
                }
                compiledOperation.getValidations().setWhiteList(whiteList);
                break;
            }
            case blackList: {
                Integer length = operation.getValidations().getRefValidations().length;
                String[] blackList = new String[length.intValue()];
                for (N2oObject.Operation.Validations.Validation validation : operation.getValidations().getRefValidations()) {
                    blackList[i] = validation.getRefId();
                    ++i;
                }
                compiledOperation.getValidations().setBlackList(blackList);
                break;
            }
        }
    }

    private static Map<String, Validation> initValidationsMap(List<Validation> validations) {
        HashMap<String, Validation> res = new HashMap<String, Validation>();
        for (Validation validation : validations) {
            res.put(validation.getId(), validation);
        }
        return res;
    }

    private CompiledObject.Operation compileOperation(N2oObject.Operation operation, CompiledObject compiled, CompileProcessor processor) {
        LinkedHashMap inParamMap = new LinkedHashMap();
        if (operation.getInParameters() != null && operation.getInParameters().length > 0) {
            for (N2oObject.Parameter parameter : operation.getInParameters()) {
                this.addParameter(parameter, compiled, p -> {
                    p.setRequired(Boolean.valueOf(CompileUtil.castDefault((Boolean)p.getRequired(), (boolean)false)));
                    inParamMap.put(p.getId(), p);
                });
            }
        }
        LinkedHashMap outParamMap = new LinkedHashMap();
        if (operation.getOutParameters() != null) {
            for (N2oObject.Parameter parameter : operation.getOutParameters()) {
                this.addParameter(parameter, compiled, p -> outParamMap.put(p.getId(), p));
            }
        }
        CompiledObject.Operation compiledOperation = new CompiledObject.Operation(inParamMap, outParamMap);
        this.initDefaultOperationProperties(compiledOperation, operation, processor);
        compiledOperation.setObjectId(compiled.getId());
        if (compiledOperation.getInParametersMap() != null) {
            for (N2oObject.Parameter parameter : compiledOperation.getInParametersMap().values()) {
                this.resolveDefaultParameter(parameter, compiled);
            }
        }
        compiledOperation.setProperties(processor.mapAttributes((ExtensionAttributesAware)operation));
        return compiledOperation;
    }

    private void initDefaultOperationProperties(CompiledObject.Operation compiledOperation, N2oObject.Operation operation, CompileProcessor p) {
        compiledOperation.setId(operation.getId());
        compiledOperation.setDescription(operation.getDescription());
        compiledOperation.setName(operation.getName());
        compiledOperation.setConfirm(operation.getConfirm());
        compiledOperation.setConfirmationText(CompileUtil.castDefault((String)operation.getConfirmationText(), (String)p.getMessage("n2o.confirm.text", new Object[0]), (String[])new String[0]));
        compiledOperation.setBulkConfirmationText(CompileUtil.castDefault((String)operation.getBulkConfirmationText(), (String)p.getMessage("n2o.confirmationGroup", new Object[0]), (String[])new String[0]));
        compiledOperation.setSuccessText(CompileUtil.castDefault((String)operation.getSuccessText(), (String)p.getMessage("n2o.success", new Object[0]), (String[])new String[0]));
        compiledOperation.setFailText(operation.getFailText());
        compiledOperation.setInvocation(operation.getInvocation());
        compiledOperation.setValidations(operation.getValidations());
        for (DefaultActions defaultOperations : DefaultActions.values()) {
            if (!defaultOperations.name().equals(operation.getId())) continue;
            compiledOperation.setFormSubmitLabel(CompileUtil.castDefault((String)operation.getFormSubmitLabel(), (String)defaultOperations.getFormSubmitLabel(), (String[])new String[0]));
            compiledOperation.setName(CompileUtil.castDefault((String)operation.getName(), (String)defaultOperations.getLabel(), (String[])new String[0]));
        }
        compiledOperation.setFormSubmitLabel(operation.getFormSubmitLabel());
    }

    private <T extends InvocationParameter> void addParameter(T parameter, CompiledObject compiled, Consumer<T> consumer) {
        this.resolveDefaultParameter(parameter, compiled);
        consumer.accept(parameter);
    }

    private <T extends InvocationParameter> void resolveDefaultParameter(T parameter, CompiledObject compiled) {
        AbstractParameter field = (AbstractParameter)compiled.getObjectFieldsMap().get(parameter.getId());
        if (parameter.getDomain() == null) {
            parameter.setDomain(this.resolveDefaultDomain(field));
        }
        if (parameter.getRequired() == null) {
            parameter.setRequired(this.resolveDefaultRequired(field));
        }
        if (parameter.getDefaultValue() == null) {
            parameter.setDefaultValue(this.resolveDefaultValue(field));
        }
        if (parameter.getNormalize() == null) {
            parameter.setNormalize(this.resolveDefaultNormalize(field));
        }
        if (parameter.getMapping() == null) {
            parameter.setMapping(this.resolveDefaultMapping(field));
        }
        if (parameter.getMapper() == null) {
            parameter.setMapper(this.resolveDefaultMapper(field));
        }
    }

    private String resolveDefaultDomain(AbstractParameter field) {
        String domain = null;
        if (field instanceof ObjectScalarField && ((ObjectScalarField)field).getDomain() != null) {
            domain = ((ObjectScalarField)field).getDomain();
        }
        return domain;
    }

    private Boolean resolveDefaultRequired(AbstractParameter field) {
        Boolean required = null;
        if (field != null) {
            required = field.getRequired();
        }
        return required;
    }

    private String resolveDefaultValue(AbstractParameter field) {
        String defaultValue = null;
        if (field instanceof ObjectScalarField && ((ObjectScalarField)field).getDefaultValue() != null) {
            defaultValue = ((ObjectScalarField)field).getDefaultValue();
        }
        return defaultValue;
    }

    private String resolveDefaultNormalize(AbstractParameter field) {
        String normalizer = null;
        if (field instanceof ObjectScalarField && ((ObjectScalarField)field).getNormalize() != null) {
            normalizer = ((ObjectScalarField)field).getNormalize();
        }
        return normalizer;
    }

    private MapperType resolveDefaultMapper(AbstractParameter field) {
        MapperType mapper = null;
        if (field instanceof ObjectScalarField && ((ObjectScalarField)field).getMapperType() != null) {
            mapper = ((ObjectScalarField)field).getMapperType();
        }
        return mapper;
    }

    private String resolveDefaultMapping(AbstractParameter field) {
        String mapping = null;
        if (field != null) {
            mapping = field.getMapping();
        }
        return mapping;
    }

    private void addOperation(CompiledObject.Operation compiledOperation, CompiledObject compiled) {
        compiled.getOperations().put(compiledOperation.getId(), compiledOperation);
    }
}

