/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.SubmitActionType;
import net.n2oapp.framework.api.metadata.global.view.ActionsBar;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateType;
import net.n2oapp.framework.api.metadata.global.view.page.N2oBasePage;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.AbstractMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.ToolbarPlaceScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.SearchBarScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetObjectScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;

public abstract class BasePageCompiler<S extends N2oBasePage, D extends StandardPage>
extends PageCompiler<S, D> {
    protected abstract void initRegions(S var1, D var2, CompileProcessor var3, PageContext var4, PageScope var5, PageRoutes var6);

    public D compilePage(S source, D page, PageContext context, CompileProcessor p, N2oRegion[] regions, SearchBarScope searchBarScope) {
        List<N2oWidget> sourceWidgets = this.collectWidgets(regions);
        String pageRoute = this.initPageRoute((N2oPage)source, context, p);
        page.setId((String)p.cast((Object)context.getClientPageId(), (Object)RouteUtil.convertPathToId(pageRoute), new Object[0]));
        PageScope pageScope = new PageScope();
        pageScope.setPageId(page.getId());
        String resultWidgetId = null;
        if (context.getSubmitOperationId() != null || SubmitActionType.copy.equals((Object)context.getSubmitActionType())) {
            pageScope.setObjectId(source.getObjectId());
            resultWidgetId = this.initResultWidgetId(context, sourceWidgets);
            pageScope.setResultWidgetId(resultWidgetId);
        }
        String pageName = (String)p.cast((Object)context.getPageName(), (Object)source.getName(), new Object[0]);
        boolean showTitle = (Boolean)p.cast((Object)source.getShowTitle(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.default.page.show_title"), Boolean.class)), new Object[]{false});
        page.setPageProperty(this.initPageName(pageName, showTitle, context, p));
        page.setProperties(p.mapAttributes(source));
        BreadcrumbList breadcrumb = this.initBreadcrumb(pageName, context, p);
        page.setBreadcrumb((List)breadcrumb);
        page.setWidgets((Map)new StrictMap());
        Models models = new Models();
        page.setModels(models);
        PageRoutes pageRoutes = new PageRoutes();
        pageRoutes.addRoute(new PageRoutes.Route(pageRoute));
        this.initDefaults(context, sourceWidgets);
        ParentRouteScope routeScope = new ParentRouteScope(pageRoute, context.getPathRouteMapping(), context.getQueryRouteMapping());
        ValidationList validationList = new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>());
        PageRoutesScope pageRoutesScope = new PageRoutesScope();
        WidgetObjectScope widgetObjectScope = new WidgetObjectScope();
        page.setWidgets(this.initWidgets(routeScope, pageRoutes, sourceWidgets, context, p, pageScope, breadcrumb, validationList, models, pageRoutesScope, widgetObjectScope, searchBarScope));
        this.registerRoutes(pageRoutes, context, p);
        page.setRoutes(pageRoutes);
        this.initRegions(source, page, p, context, pageScope, pageRoutes);
        CompiledObject object = source.getObjectId() != null ? (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId())) : null;
        page.setObject(object);
        page.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)this.getPropertyPageSrc()), String.class)), new Object[0]));
        page.setProperties(p.mapAttributes(source));
        if (context.getSubmitOperationId() != null || SubmitActionType.copy.equals((Object)context.getSubmitActionType())) {
            this.initToolbarGenerate(source, resultWidgetId);
        }
        MetaActions metaActions = new MetaActions();
        this.compileToolbarAndAction((StandardPage)page, source, context, p, metaActions, pageScope, routeScope, pageRoutes, object, breadcrumb, validationList, page.getWidgets(), widgetObjectScope);
        page.setActions((Map)metaActions);
        return page;
    }

    protected List<N2oWidget> collectWidgets(N2oRegion[] regions) {
        ArrayList<N2oWidget> result = new ArrayList<N2oWidget>();
        HashMap<String, Integer> ids = new HashMap<String, Integer>();
        if (regions != null) {
            for (N2oRegion region : regions) {
                if (!ids.containsKey(region.getAlias())) {
                    ids.put(region.getAlias(), 1);
                }
                if (region.getWidgets() == null) continue;
                result.addAll(Arrays.stream(region.getWidgets()).map(w -> {
                    if (w.getId() == null) {
                        String widgetPrefix = region.getAlias();
                        w.setId(widgetPrefix + ids.put(widgetPrefix, (Integer)ids.get(widgetPrefix) + 1));
                    }
                    return w;
                }).collect(Collectors.toList()));
            }
        }
        return result;
    }

    private void initDefaults(PageContext context, List<N2oWidget> sourceWidgets) {
        if (context.getPreFilters() != null && !context.getPreFilters().isEmpty() || context.getUpload() != null) {
            N2oWidget widget = this.initResultWidget(context, sourceWidgets);
            widget.addPreFilters(context.getPreFilters());
            widget.setUpload(context.getUpload());
        }
    }

    private String initResultWidgetId(PageContext context, List<N2oWidget> sourceWidgets) {
        String resultWidgetId = context.getResultWidgetId();
        if (resultWidgetId == null) {
            List<N2oWidget> sourceIndependents = this.getSourceIndependents(sourceWidgets);
            if (sourceIndependents.size() == 1) {
                resultWidgetId = sourceIndependents.get(0).getId();
            } else {
                throw new N2oException("Can't get result widget id. There were two independent's widgets");
            }
        }
        return resultWidgetId;
    }

    private N2oWidget initResultWidget(PageContext context, List<N2oWidget> sourceWidgets) {
        String resultWidgetId = context.getResultWidgetId();
        if (resultWidgetId != null) {
            for (N2oWidget sourceWidget : sourceWidgets) {
                if (sourceWidget.getId() == null || !sourceWidget.getId().equals(resultWidgetId)) continue;
                return sourceWidget;
            }
            throw new N2oException("Widget " + resultWidgetId + " not found!");
        }
        List<N2oWidget> sourceIndependents = this.getSourceIndependents(sourceWidgets);
        if (sourceIndependents.size() == 1) {
            return sourceIndependents.get(0);
        }
        throw new N2oException("Can't get result widget id. There were two independent's widgets");
    }

    private void compileToolbarAndAction(StandardPage compiled, S source, PageContext context, CompileProcessor p, MetaActions metaActions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList, Map<String, Widget> widgets, WidgetObjectScope widgetObjectScope) {
        this.actionsToToolbar(source);
        compiled.setToolbar(this.compileToolbar(source, context, p, metaActions, pageScope, routeScope, pageRoutes, object, breadcrumbs, validationList, widgetObjectScope));
        this.compileActions(source, context, p, metaActions, pageScope, routeScope, pageRoutes, breadcrumbs, object, validationList, widgets);
    }

    private void actionsToToolbar(S source) {
        if (source.getActions() == null || source.getToolbars() == null) {
            return;
        }
        HashMap<String, ActionsBar> actionMap = new HashMap<String, ActionsBar>();
        Stream.of(source.getActions()).forEach(a -> actionMap.put(a.getId(), (ActionsBar)a));
        for (N2oToolbar toolbar : source.getToolbars()) {
            if (toolbar.getItems() == null) continue;
            ToolbarItem[] toolbarItems = toolbar.getItems();
            this.copyActionForToolbarItem(actionMap, toolbarItems);
        }
    }

    private void copyActionForToolbarItem(Map<String, ActionsBar> actionMap, ToolbarItem[] toolbarItems) {
        for (ToolbarItem item : toolbarItems) {
            if (item instanceof N2oButton || item instanceof N2oMenuItem) {
                this.copyAction((AbstractMenuItem)item, actionMap);
                continue;
            }
            if (item instanceof N2oSubmenu) {
                for (N2oMenuItem subItem : ((N2oSubmenu)item).getMenuItems()) {
                    this.copyAction((AbstractMenuItem)subItem, actionMap);
                }
                continue;
            }
            if (!(item instanceof N2oGroup)) continue;
            this.copyActionForToolbarItem(actionMap, (ToolbarItem[])((N2oGroup)item).getItems());
        }
    }

    private void copyAction(AbstractMenuItem item, Map<String, ActionsBar> actionMap) {
        if (item.getAction() == null && item.getActionId() != null) {
            ActionsBar actionsBar = actionMap.get(item.getActionId());
            if (actionsBar == null) {
                throw new N2oException("Toolbar has reference to nonexistent action by actionId {0}!").addData(new Object[]{item.getActionId()});
            }
            item.setAction(actionsBar.getAction());
            if (item.getModel() == null) {
                item.setModel(actionsBar.getModel());
            }
            if (item.getWidgetId() == null) {
                item.setWidgetId(actionsBar.getWidgetId());
            }
            if (item.getLabel() == null) {
                item.setLabel(actionsBar.getLabel());
            }
            if (item.getIcon() == null) {
                item.setIcon(actionsBar.getIcon());
            }
        }
    }

    private Toolbar compileToolbar(S source, PageContext context, CompileProcessor p, MetaActions metaActions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList, WidgetObjectScope widgetObjectScope) {
        if (source.getToolbars() == null) {
            return null;
        }
        ToolbarPlaceScope toolbarPlaceScope = new ToolbarPlaceScope((String)p.resolve(Placeholders.property((String)"n2o.api.page.toolbar.place"), String.class));
        Toolbar toolbar = new Toolbar();
        for (N2oToolbar n2oToolbar : source.getToolbars()) {
            toolbar.putAll((Map)p.compile((Object)n2oToolbar, (CompileContext)context, new Object[]{metaActions, pageScope, routeScope, pageRoutes, object, breadcrumbs, validationList, new IndexScope(), widgetObjectScope, toolbarPlaceScope}));
        }
        return toolbar;
    }

    private Map<String, Widget> initWidgets(ParentRouteScope routeScope, PageRoutes pageRoutes, List<N2oWidget> sourceWidgets, PageContext context, CompileProcessor p, PageScope pageScope, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, PageRoutesScope pageRoutesScope, WidgetObjectScope widgetObjectScope, SearchBarScope searchBarScope) {
        StrictMap compiledWidgets = new StrictMap();
        IndexScope indexScope = new IndexScope();
        List<N2oWidget> independents = this.getSourceIndependents(sourceWidgets);
        if (searchBarScope != null && searchBarScope.getWidgetId() == null) {
            searchBarScope.setWidgetId(independents.get(0).getId());
        }
        independents.forEach(arg_0 -> this.lambda$initWidgets$2(pageRoutes, routeScope, sourceWidgets, (Map)compiledWidgets, context, p, pageScope, breadcrumbs, validationList, models, indexScope, pageRoutesScope, widgetObjectScope, searchBarScope, arg_0));
        return compiledWidgets;
    }

    private void compileWidget(N2oWidget w, PageRoutes routes, ParentRouteScope parentRoute, String parentWidgetId, String parentQueryId, List<N2oWidget> sourceWidgets, Map<String, Widget> compiledWidgets, PageContext context, CompileProcessor p, PageScope pageScope, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, IndexScope indexScope, PageRoutesScope pageRoutesScope, WidgetObjectScope widgetObjectScope, SearchBarScope searchBarScope) {
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setDependsOnWidgetId(parentWidgetId);
        widgetScope.setDependsOnQueryId(parentQueryId);
        Widget compiledWidget = (Widget)p.compile((Object)w, (CompileContext)context, new Object[]{indexScope, routes, pageScope, widgetScope, parentRoute, breadcrumbs, validationList, models, pageRoutesScope, widgetObjectScope, searchBarScope});
        compiledWidgets.put(compiledWidget.getId(), compiledWidget);
        ParentRouteScope parentRouteScope = new ParentRouteScope(compiledWidget.getRoute(), parentRoute);
        this.getDetails(w.getId(), sourceWidgets).forEach(detWgt -> this.compileWidget((N2oWidget)detWgt, routes, parentRouteScope, compiledWidget.getId(), compiledWidget.getQueryId(), sourceWidgets, compiledWidgets, context, p, pageScope, breadcrumbs, validationList, models, indexScope, pageRoutesScope, widgetObjectScope, searchBarScope));
    }

    private void initToolbarGenerate(S source, String resultWidgetId) {
        N2oToolbar n2oToolbar = new N2oToolbar();
        String[] generate = new String[]{GenerateType.submit.name(), GenerateType.close.name()};
        n2oToolbar.setGenerate(generate);
        n2oToolbar.setTargetWidgetId(resultWidgetId);
        if (source.getToolbars() == null) {
            source.setToolbars(new N2oToolbar[0]);
        }
        int length = source.getToolbars().length;
        N2oToolbar[] n2oToolbars = new N2oToolbar[length + 1];
        System.arraycopy(source.getToolbars(), 0, n2oToolbars, 0, length);
        n2oToolbars[length] = n2oToolbar;
        source.setToolbars(n2oToolbars);
    }

    private List<N2oWidget> getSourceIndependents(List<N2oWidget> sourceWidgets) {
        ArrayList<N2oWidget> independents = new ArrayList<N2oWidget>();
        for (N2oWidget widget : sourceWidgets) {
            if (widget.getDependsOn() != null) continue;
            independents.add(widget);
        }
        return independents;
    }

    private List<N2oWidget> getDetails(String widgetId, List<N2oWidget> widgets) {
        ArrayList<N2oWidget> details = new ArrayList<N2oWidget>();
        for (N2oWidget widget : widgets) {
            if (widget.getDependsOn() == null || !widget.getDependsOn().equals(widgetId)) continue;
            details.add(widget);
        }
        return details;
    }

    private void compileActions(S source, PageContext context, CompileProcessor p, MetaActions actions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, BreadcrumbList breadcrumbs, CompiledObject object, ValidationList validationList, Map<String, Widget> widgets) {
        if (source.getActions() != null) {
            Stream.of(source.getActions()).forEach(a -> {
                a.getAction().setId(a.getId());
                Widget widget = null;
                CompiledObject compiledObject = object;
                if (widgets.containsKey(a.getWidgetId())) {
                    widget = (Widget)widgets.get(a.getWidgetId());
                }
                if (widget != null) {
                    compiledObject = new CompiledObject();
                    compiledObject.setId(widget.getObjectId());
                }
                Action action = (Action)p.compile((Object)a.getAction(), (CompileContext)context, new Object[]{pageScope, routeScope, pageRoutes, compiledObject, breadcrumbs, validationList, new ComponentScope(a)});
                actions.addAction(a.getId(), action);
            });
        }
    }

    private /* synthetic */ void lambda$initWidgets$2(PageRoutes pageRoutes, ParentRouteScope routeScope, List sourceWidgets, Map compiledWidgets, PageContext context, CompileProcessor p, PageScope pageScope, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, IndexScope indexScope, PageRoutesScope pageRoutesScope, WidgetObjectScope widgetObjectScope, SearchBarScope searchBarScope, N2oWidget w) {
        this.compileWidget(w, pageRoutes, routeScope, null, null, sourceWidgets, compiledWidgets, context, p, pageScope, breadcrumbs, validationList, models, indexScope, pageRoutesScope, widgetObjectScope, searchBarScope);
    }
}

