/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.action.LabelType;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.AbstractMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Confirm;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ConfirmType;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.GroupItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButtonCondition;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeAction;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Condition;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.MenuItem;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetObjectScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class BaseButtonCompiler<S extends GroupItem, B extends AbstractButton>
implements BaseSourceCompiler<B, S, CompileContext<?, ?>> {
    protected void initItem(MenuItem button, AbstractMenuItem source, IndexScope idx, CompileContext<?, ?> context, CompileProcessor p) {
        Action action;
        button.setId((String)p.cast((Object)source.getId(), (Object)source.getActionId(), new Object[]{"menuItem" + idx.get()}));
        source.setId(button.getId());
        button.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        if (source.getType() != null && source.getType() == LabelType.icon) {
            button.setIcon(source.getIcon());
        } else if (source.getType() != null && source.getType() == LabelType.text) {
            button.setLabel(source.getLabel());
        } else {
            button.setIcon(source.getIcon());
            button.setLabel(source.getLabel());
        }
        CompiledObject.Operation operation = null;
        CompiledObject compiledObject = null;
        WidgetObjectScope widgetObjectScope = (WidgetObjectScope)p.getScope(WidgetObjectScope.class);
        if (widgetObjectScope != null) {
            if (widgetObjectScope.size() == 1 && source.getWidgetId() == null) {
                source.setWidgetId((String)widgetObjectScope.keySet().iterator().next());
            }
            if (widgetObjectScope.containsKey(source.getWidgetId())) {
                compiledObject = widgetObjectScope.getObject(source.getWidgetId());
            }
        }
        if (compiledObject == null) {
            compiledObject = (CompiledObject)p.getScope(CompiledObject.class);
        }
        if ((action = this.compileAction(button, source, context, p, compiledObject)) != null) {
            button.setAction(action);
            if (action instanceof InvokeAction) {
                operation = compiledObject != null && compiledObject.getOperations() != null && compiledObject.getOperations().containsKey(((InvokeAction)action).getOperationId()) ? (CompiledObject.Operation)compiledObject.getOperations().get(((InvokeAction)action).getOperationId()) : null;
            }
        }
        this.initConfirm(button, source, context, p, operation);
        button.setClassName(source.getClassName());
        button.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        String hint = LabelType.icon.equals((Object)source.getType()) ? (String)p.cast((Object)source.getDescription(), (Object)source.getLabel(), new Object[0]) : source.getDescription();
        if (hint != null) {
            button.setHint(hint.trim());
            if (source.getTooltipPosition() != null) {
                button.setHintPosition(source.getTooltipPosition());
            } else {
                button.setHintPosition(source instanceof N2oButton ? (String)p.resolve(Placeholders.property((String)"n2o.api.button.tooltip_position"), String.class) : (String)p.resolve(Placeholders.property((String)"n2o.api.menuitem.tooltip_position"), String.class));
            }
        }
        if (source.getModel() == null) {
            source.setModel(ReduxModel.RESOLVE);
        }
        this.compileConditionsAndDependencies(button, source, context, p);
        button.setValidate(source.getValidate());
    }

    private Action compileAction(MenuItem button, AbstractMenuItem source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject compiledObject) {
        Action action = null;
        if (source.getActionId() != null) {
            MetaActions metaActions = (MetaActions)p.getScope(MetaActions.class);
            action = (Action)metaActions.get(source.getActionId());
        } else {
            N2oAction butAction = source.getAction();
            if (butAction != null) {
                butAction.setId((String)p.cast((Object)butAction.getId(), (Object)button.getId(), new Object[0]));
                action = (Action)p.compile((Object)butAction, context, new Object[]{compiledObject, new ComponentScope(source)});
            }
        }
        return action;
    }

    private void initConfirm(MenuItem button, AbstractMenuItem source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject.Operation operation) {
        if (!(source.getConfirm() != null && source.getConfirm().booleanValue() || source.getConfirm() == null && operation != null && operation.getConfirm() != null && operation.getConfirm().booleanValue())) {
            return;
        }
        Confirm confirm = new Confirm();
        confirm.setMode((ConfirmType)p.cast((Object)source.getConfirmType(), (Object)ConfirmType.modal, new Object[0]));
        confirm.setText((String)p.cast((Object)source.getConfirmText(), (Object)(operation != null ? operation.getConfirmationText() : null), new Object[]{p.getMessage("n2o.confirm.text", new Object[0])}));
        confirm.setTitle((String)p.cast((Object)source.getConfirmTitle(), (Object)(operation != null ? operation.getFormSubmitLabel() : null), new Object[]{p.getMessage("n2o.confirm.title", new Object[0])}));
        confirm.setOkLabel((String)p.cast((Object)source.getConfirmOkLabel(), (Object)p.getMessage("n2o.confirm.default.okLabel", new Object[0]), new Object[0]));
        confirm.setCancelLabel((String)p.cast((Object)source.getConfirmCancelLabel(), (Object)p.getMessage("n2o.confirm.default.cancelLabel", new Object[0]), new Object[0]));
        if (StringUtils.hasLink((String)confirm.getText())) {
            Set links = StringUtils.collectLinks((String)confirm.getText());
            String text = Placeholders.js((String)("'" + confirm.getText() + "'"));
            for (String link : links) {
                text = text.replace(Placeholders.ref((String)link), "' + this." + link + " + '");
            }
            confirm.setText(text);
        }
        if (StringUtils.isJs((Object)confirm.getText())) {
            String widgetId = this.initWidgetId(source, context, p);
            ReduxModel reduxModel = source.getModel();
            confirm.setModelLink(new ModelLink(reduxModel == null ? ReduxModel.RESOLVE : reduxModel, widgetId).getBindLink());
        }
        button.setConfirm(confirm);
    }

    protected String initWidgetId(AbstractMenuItem source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (source.getWidgetId() != null) {
            return pageScope == null ? source.getWidgetId() : pageScope.getGlobalWidgetId(source.getWidgetId());
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getClientWidgetId();
        }
        if (context instanceof PageContext && ((PageContext)context).getResultWidgetId() != null) {
            return pageScope.getGlobalWidgetId(((PageContext)context).getResultWidgetId());
        }
        throw new N2oException("Unknown widgetId for invoke action!");
    }

    protected void compileConditionsAndDependencies(MenuItem button, AbstractMenuItem source, CompileContext<?, ?> context, CompileProcessor p) {
        String widgetId = this.initWidgetId(source, context, p);
        ArrayList<Condition> enabledConditions = new ArrayList<Condition>();
        if (source.getVisibilityConditions() != null) {
            button.getConditions().put(ValidationType.visible, this.compileConditions(source.getVisibilityConditions(), source.getModel(), widgetId));
        }
        if (source.getEnablingConditions() != null) {
            enabledConditions.addAll(this.compileConditions(source.getEnablingConditions(), source.getModel(), widgetId));
        }
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (source.getModel() == null || source.getModel().equals((Object)ReduxModel.RESOLVE) && (componentScope == null || componentScope.unwrap(N2oCell.class) == null)) {
            Condition condition = new Condition();
            condition.setExpression("!_.isEmpty(this)");
            condition.setModelLink(new ModelLink(ReduxModel.RESOLVE, widgetId).getBindLink());
            enabledConditions.add(condition);
        }
        if (!enabledConditions.isEmpty()) {
            button.getConditions().put(ValidationType.enabled, enabledConditions);
        }
        if (source.getDependencies() != null) {
            this.compileDependencies(source.getDependencies(), button, widgetId, p);
        }
        if (componentScope != null && componentScope.unwrap(N2oCell.class) != null) {
            button.setVisible((Object)p.resolveJS(source.getVisible()));
            button.setEnabled((Object)p.resolveJS(source.getEnabled()));
        } else {
            if (StringUtils.isLink((Object)source.getVisible())) {
                this.compileLinkCondition(button, widgetId, ValidationType.visible, source.getVisible());
            } else {
                button.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
            }
            if (StringUtils.isLink((Object)source.getEnabled())) {
                this.compileLinkCondition(button, widgetId, ValidationType.enabled, source.getEnabled());
            } else {
                button.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
            }
        }
    }

    private List<Condition> compileConditions(N2oButtonCondition[] conditions, ReduxModel model, String widgetId) {
        ArrayList<Condition> result = new ArrayList<Condition>();
        for (N2oButtonCondition n2oCondition : conditions) {
            Condition condition = new Condition();
            condition.setExpression(n2oCondition.getExpression().trim());
            condition.setModelLink(new ModelLink(model, widgetId).getBindLink());
            result.add(condition);
        }
        return result;
    }

    private void compileLinkCondition(MenuItem button, String widgetId, ValidationType type, String linkCondition) {
        Condition condition = new Condition();
        condition.setExpression(linkCondition.substring(1, linkCondition.length() - 1));
        condition.setModelLink(new ModelLink(ReduxModel.RESOLVE, widgetId).getBindLink());
        if (!button.getConditions().containsKey(type)) {
            button.getConditions().put(type, new ArrayList());
        }
        ((List)button.getConditions().get(type)).add(condition);
    }

    private void compileDependencies(AbstractMenuItem.Dependency[] dependencies, MenuItem button, String widgetId, CompileProcessor p) {
        for (AbstractMenuItem.Dependency d : dependencies) {
            ValidationType validationType = null;
            if (d instanceof AbstractMenuItem.EnablingDependency) {
                validationType = ValidationType.enabled;
            } else if (d instanceof AbstractMenuItem.VisibilityDependency) {
                validationType = ValidationType.visible;
            }
            if (d.getOn() != null) {
                for (String on : d.getOn()) {
                    this.compileCondition(d, button, validationType, widgetId, on, p);
                }
                continue;
            }
            this.compileCondition(d, button, validationType, widgetId, null, p);
        }
    }

    private void compileCondition(AbstractMenuItem.Dependency dependency, MenuItem menuItem, ValidationType validationType, String widgetId, String fieldId, CompileProcessor p) {
        PageScope pageScope;
        String refWidgetId = null;
        if (dependency.getRefWidgetId() != null && (pageScope = (PageScope)p.getScope(PageScope.class)) != null) {
            refWidgetId = pageScope.getGlobalWidgetId(dependency.getRefWidgetId());
        }
        refWidgetId = (String)p.cast(refWidgetId, (Object)widgetId, new Object[0]);
        ReduxModel refModel = (ReduxModel)p.cast((Object)dependency.getRefModel(), (Object)ReduxModel.RESOLVE, new Object[0]);
        Condition condition = new Condition();
        condition.setExpression(ScriptProcessor.resolveFunction((String)dependency.getValue()));
        condition.setModelLink(new ModelLink(refModel, refWidgetId, fieldId).getBindLink());
        if (dependency instanceof AbstractMenuItem.EnablingDependency) {
            condition.setMessage(((AbstractMenuItem.EnablingDependency)dependency).getMessage());
        }
        if (!menuItem.getConditions().containsKey(validationType)) {
            menuItem.getConditions().put(validationType, new ArrayList());
        }
        ((List)menuItem.getConditions().get(validationType)).add(condition);
    }
}

