/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.widget;

import java.util.ArrayList;
import java.util.Arrays;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import org.springframework.stereotype.Component;

@Component
public class WidgetValidator
implements SourceValidator<N2oWidget>,
SourceClassAware {
    /*
     * WARNING - void declaration
     */
    public void validate(N2oWidget n2oWidget, ValidateProcessor p) {
        N2oQuery query = null;
        if (n2oWidget.getQueryId() != null) {
            p.checkForExists(n2oWidget.getQueryId(), N2oQuery.class, "\u0412\u0438\u0434\u0436\u0435\u0442 '" + n2oWidget.getId() + "' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 '" + n2oWidget.getQueryId() + "'");
            query = (N2oQuery)p.getOrNull(n2oWidget.getQueryId(), N2oQuery.class);
        }
        if (n2oWidget.getDefaultValuesQueryId() != null) {
            p.checkForExists(n2oWidget.getDefaultValuesQueryId(), N2oQuery.class, "\u0412\u0438\u0434\u0436\u0435\u0442 '" + n2oWidget.getId() + "' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 '" + n2oWidget.getDefaultValuesQueryId() + "'");
            query = (N2oQuery)p.getOrNull(n2oWidget.getDefaultValuesQueryId(), N2oQuery.class);
        }
        N2oObject object = null;
        if (n2oWidget.getObjectId() != null) {
            p.checkForExists(n2oWidget.getObjectId(), N2oObject.class, "\u0412\u0438\u0434\u0436\u0435\u0442 '" + n2oWidget.getId() + "' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 '" + n2oWidget.getObjectId() + "'");
            object = (N2oObject)p.getOrNull(n2oWidget.getObjectId(), N2oObject.class);
        }
        if (n2oWidget.getToolbars() != null) {
            ArrayList<Object> menuItems = new ArrayList<Object>();
            N2oToolbar[] n2oToolbarArray = n2oWidget.getToolbars();
            int n = n2oToolbarArray.length;
            for (int i = 0; i < n; ++i) {
                N2oToolbar toolbar = n2oToolbarArray[i];
                if (toolbar.getItems() == null) continue;
                for (ToolbarItem toolbarItem : toolbar.getItems()) {
                    if (toolbarItem instanceof N2oButton) {
                        menuItems.add((N2oButton)toolbarItem);
                        continue;
                    }
                    if (!(toolbarItem instanceof N2oSubmenu)) continue;
                    menuItems.addAll(Arrays.asList(((N2oSubmenu)toolbarItem).getMenuItems()));
                }
            }
            p.safeStreamOf(menuItems).forEach(menuItem -> p.validate((Source)menuItem.getAction(), new Object[0]));
            p.checkIdsUnique(menuItems, "MenuItem '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '" + n2oWidget.getId() + "'!");
        }
        if (n2oWidget.getPreFilters() != null) {
            if (query == null) {
                throw new N2oMetadataValidationException("\u0412\u0438\u0434\u0436\u0435\u0442 '" + n2oWidget.getId() + "' \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u044b, \u043d\u043e \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0432\u044b\u0431\u043e\u0440\u043a\u0430");
            }
            if (query.getFields() == null) {
                throw new N2oMetadataValidationException("\u0412\u0438\u0434\u0436\u0435\u0442 '" + n2oWidget.getId() + "' \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u044b, \u043d\u043e \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '" + query.getId() + "' \u043d\u0435\u0442 fields!");
            }
            for (N2oPreFilter preFilter : n2oWidget.getPreFilters()) {
                void var13_20;
                if (!(preFilter.getValue() == null || preFilter.getParam() == null || preFilter.getRoutable() != null && preFilter.getRoutable().booleanValue())) {
                    throw new N2oMetadataValidationException("\u0412 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u0435 \u043f\u043e \u043f\u043e\u043b\u044e '" + (preFilter.getFieldId() == null ? "" : preFilter.getFieldId()) + "' \u0443\u043a\u0430\u0437\u0430\u043d value \u0438 param, \u043d\u043e \u043f\u0440\u0438 \u044d\u0442\u043e\u043c routable=false, \u0447\u0442\u043e \u043f\u0440\u043e\u0442\u0438\u0432\u043e\u0440\u0435\u0447\u0438\u0442 \u043b\u043e\u0433\u0438\u043a\u0435 \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432!");
                }
                ToolbarItem exField = null;
                for (ToolbarItem toolbarItem : query.getFields()) {
                    if (!preFilter.getFieldId().equals(toolbarItem.getId())) continue;
                    exField = toolbarItem;
                    break;
                }
                if (exField == null) {
                    throw new N2oMetadataValidationException("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '" + (query.getId() == null ? "" : query.getId()) + "' \u043d\u0435\u0442 field '" + preFilter.getFieldId() + "'!");
                }
                if (exField.getFilterList() == null) {
                    throw new N2oMetadataValidationException("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '" + (query.getId() == null ? "" : query.getId()) + "' field '" + preFilter.getFieldId() + "' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432!");
                }
                N2oQuery.Filter exFilter = null;
                N2oQuery.Filter[] filterArray = exField.getFilterList();
                int n = filterArray.length;
                boolean bl = false;
                while (var13_20 < n) {
                    N2oQuery.Filter filter = filterArray[var13_20];
                    if (preFilter.getType() == filter.getType()) {
                        exFilter = filter;
                        break;
                    }
                    ++var13_20;
                }
                if (exFilter == null) {
                    throw new N2oMetadataValidationException("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '" + (query.getId() == null ? "" : query.getId()) + "' field '" + preFilter.getFieldId() + "' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0444\u0438\u043b\u044c\u0442\u0440 \u0442\u0438\u043f\u0430 '" + preFilter.getType() + "'!");
                }
                if (n2oWidget.getDependsOn() != null || n2oWidget.getDetailFieldId() != null || preFilter.getRefWidgetId() != null || !StringUtils.hasLink((String)preFilter.getValue())) continue;
                throw new N2oMetadataValidationException("\u0412 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '" + (n2oWidget.getId() == null ? "" : n2oWidget.getId()) + "' \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u0430 '" + preFilter.getFieldId() + "' \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439, \u043d\u043e \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u043d\u0435\u0435 \u043f\u0440\u043e\u043f\u0438\u0441\u0430\u043d\u0430!");
            }
        }
        p.safeStreamOf((Object[])n2oWidget.getActions()).forEach(actionsBar -> p.validate((Source)actionsBar.getAction(), new Object[0]));
    }

    public Class<? extends Source> getSourceClass() {
        return N2oWidget.class;
    }
}

