/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.query;

import java.util.List;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oSqlDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.RestErrorMapping;
import net.n2oapp.framework.api.metadata.global.dao.execution.defaults.Calculation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.Argument;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oJavaMethod;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oRestInvocation;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.RestErrorMappingReader;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom2.Element;

public class ExecutionReaderUtil {
    private static final Calculation SORTING_CALCULATION = (expression, id) -> "sortings=" + expression + "::direction";

    public static void fieldsDefault(N2oQuery n2oQuery, Element executionElement) {
        block7: {
            block8: {
                block6: {
                    if (!(n2oQuery.getLists()[0].getInvocation() instanceof N2oSqlDataProvider)) break block6;
                    String alias = ReaderJdomUtil.getElementString((Element)executionElement.getChildren().get(0), "alias");
                    if (alias == null || n2oQuery.getFields() == null) break block7;
                    int i = 0;
                    for (N2oQuery.Field field : n2oQuery.getFields()) {
                        if (alias != null && field.getExpression() == null && field.getNoDisplay() != null && !field.getNoDisplay().booleanValue()) {
                            field.setExpression(alias != null ? alias + "." + field.getId() : field.getId());
                        }
                        if (field.getNoDisplay() != null && field.getNoDisplay().booleanValue()) continue;
                        field.setSelectMapping("[" + i + "]");
                        ++i;
                    }
                    break block7;
                }
                if (!(n2oQuery.getLists()[0].getInvocation() instanceof N2oRestInvocation)) break block8;
                if (n2oQuery.getFields() == null) break block7;
                for (N2oQuery.Field field : n2oQuery.getFields()) {
                    if (field.getSortingBody() == null) {
                        field.setSortingBody(SORTING_CALCULATION.calculate(field.getExpression(), field.getId()));
                    }
                    field.setSelectMapping(field.getSelectBody());
                }
                break block7;
            }
            if (n2oQuery.getFields() != null) {
                for (N2oQuery.Field field : n2oQuery.getFields()) {
                    if (field.getSelectMapping() != null) continue;
                    field.setSelectMapping(field.getSelectBody() == null ? field.getId() : field.getSelectBody());
                }
            }
        }
    }

    public static void readExecution(N2oQuery n2oQuery, Element executionElement) {
        Element execution;
        if (executionElement == null) {
            return;
        }
        List executionElements = executionElement.getChildren();
        if (executionElements.isEmpty()) {
            MetadataReaderException.throwMissingAtLeastOneElement(executionElement);
        }
        if (executionElements.size() > 1) {
            MetadataReaderException.throwMoreThanOneChildElement(executionElement);
        }
        if ((execution = (Element)executionElements.get(0)).getName().equals("sql")) {
            ExecutionReaderUtil.readSqlExecution(n2oQuery, execution);
        } else if (execution.getName().equals("rest")) {
            ExecutionReaderUtil.readRestExecution(n2oQuery, execution);
        } else if (execution.getName().equals("java-criteria")) {
            ExecutionReaderUtil.readJavaCriteria(n2oQuery, execution);
        } else {
            MetadataReaderException.throwExpectedElement(execution, "sql, rest or java-criteria");
        }
    }

    private static void readJavaCriteria(N2oQuery n2oQuery, Element execution) {
        N2oJavaMethod javaCriteria = new N2oJavaMethod();
        javaCriteria.setBean(ReaderJdomUtil.getAttributeString(execution, "bean-name"));
        javaCriteria.setName("getCollectionPage");
        Argument argument = new Argument();
        argument.setClassName(ReaderJdomUtil.getAttributeString(execution, "criteria-class"));
        argument.setType(Argument.Type.CRITERIA);
        javaCriteria.setArguments(new Argument[]{argument});
        javaCriteria.setNamespaceUri(execution.getNamespaceURI());
        N2oQuery.Selection selection = new N2oQuery.Selection(N2oQuery.Selection.Type.list, (N2oInvocation)javaCriteria);
        selection.setCountMapping("count");
        selection.setResultMapping("collection");
        n2oQuery.setLists(new N2oQuery.Selection[]{selection});
    }

    private static void readSqlExecution(N2oQuery n2oQuery, Element execution) {
        N2oSqlDataProvider sqlQuery = new N2oSqlDataProvider();
        String itemsSql = ReaderJdomUtil.getElementString(execution, "items-query");
        if (itemsSql != null) {
            itemsSql = itemsSql.replaceAll("[ \n]:where[ \n]", " :filters ");
            if (!(itemsSql = itemsSql.replaceAll("[ \n]:order[ \n]", " :sorting ")).contains(":limit")) {
                itemsSql = itemsSql + " limit :limit";
            }
            if (!itemsSql.contains(":offset")) {
                itemsSql = itemsSql + " offset :offset";
            }
        }
        sqlQuery.setQuery(itemsSql);
        sqlQuery.setNamespaceUri(execution.getNamespaceURI());
        sqlQuery.setRowMapper("index");
        n2oQuery.setLists(new N2oQuery.Selection[]{new N2oQuery.Selection(N2oQuery.Selection.Type.list, (N2oInvocation)sqlQuery)});
        N2oSqlDataProvider countQuery = new N2oSqlDataProvider();
        String countSql = ReaderJdomUtil.getElementString(execution, "count-query");
        if (countSql != null) {
            countSql = countSql.replaceAll("[ \n]:where[ \n]", " :filters ");
            countSql = countSql.replaceAll("[ \n]:order[ \n]", " :sorting ");
        }
        countQuery.setQuery(countSql);
        countQuery.setNamespaceUri(execution.getNamespaceURI());
        countQuery.setRowMapper("index");
        N2oQuery.Selection countSelection = new N2oQuery.Selection(N2oQuery.Selection.Type.count, (N2oInvocation)countQuery);
        countSelection.setCountMapping("[0][0]");
        n2oQuery.setCounts(new N2oQuery.Selection[]{countSelection});
    }

    private static void readRestExecution(N2oQuery n2oQuery, Element execution) {
        String queryById;
        String dateFormat = ReaderJdomUtil.getElementString(execution, "date-format");
        String resultMapping = null;
        String countMapping = null;
        Element responseMapping = execution.getChild("response-mapping", execution.getNamespace());
        if (responseMapping != null) {
            resultMapping = ReaderJdomUtil.getAttributeString(responseMapping, "collection");
            countMapping = ReaderJdomUtil.getAttributeString(responseMapping, "count");
        }
        String proxyHost = null;
        Integer proxyPort = null;
        Element proxyElem = execution.getChild("proxy", execution.getNamespace());
        if (proxyElem != null) {
            proxyHost = ReaderJdomUtil.getAttributeString(proxyElem, "host");
            proxyPort = ReaderJdomUtil.getAttributeInteger(proxyElem, "port");
        }
        RestErrorMapping errorMapping = RestErrorMappingReader.read(execution.getChild("error-mapping", execution.getNamespace()), execution.getNamespace());
        String query = ReaderJdomUtil.getElementString(execution, "query");
        if (query != null) {
            N2oQuery.Selection listSel = new N2oQuery.Selection(N2oQuery.Selection.Type.list);
            listSel.setResultMapping(resultMapping != null ? Placeholders.spel((String)resultMapping) : Placeholders.spel((String)"collection"));
            listSel.setCountMapping(countMapping != null ? Placeholders.spel((String)countMapping) : Placeholders.spel((String)"count"));
            N2oRestInvocation listInv = new N2oRestInvocation();
            query = query.trim();
            listInv.setMethod("GET");
            listInv.setQuery(query);
            listInv.setDateFormat(dateFormat);
            listInv.setProxyHost(proxyHost);
            listInv.setProxyPort(proxyPort);
            listInv.setErrorMapping(errorMapping);
            listInv.setNamespaceUri(execution.getNamespaceURI());
            listSel.setInvocation((N2oInvocation)listInv);
            n2oQuery.setLists(new N2oQuery.Selection[]{listSel});
        }
        if ((queryById = ReaderJdomUtil.getElementString(execution, "query-by-id")) != null) {
            N2oQuery.Selection uniqueSel = new N2oQuery.Selection(N2oQuery.Selection.Type.unique);
            uniqueSel.setResultMapping("#this");
            N2oRestInvocation uniqueInv = new N2oRestInvocation();
            queryById = queryById.trim();
            uniqueInv.setMethod("GET");
            uniqueInv.setQuery(queryById);
            uniqueInv.setDateFormat(dateFormat);
            uniqueInv.setProxyHost(proxyHost);
            uniqueInv.setProxyPort(proxyPort);
            uniqueInv.setErrorMapping(errorMapping);
            uniqueInv.setNamespaceUri(execution.getNamespaceURI());
            uniqueSel.setInvocation((N2oInvocation)uniqueInv);
            n2oQuery.setUniques(new N2oQuery.Selection[]{uniqueSel});
        }
    }
}

