/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.tools.showModal;

import net.n2oapp.framework.api.metadata.event.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.tools.AfterCancel;
import net.n2oapp.framework.api.metadata.global.view.tools.AfterSubmit;
import net.n2oapp.framework.api.ui.FormModel;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.tools.PreFilterReaderV1Util;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class N2oStandardShowModalReaderUtil {
    public static void getShowModalDefinition(Element element, N2oAbstractPageAction showModal) {
        try {
            Namespace namespace = element.getNamespace();
            showModal.setPageId(ReaderJdomUtil.getAttributeString(element, "page-id"));
            showModal.setPageName(ReaderJdomUtil.getAttributeString(element, "page-name"));
            Element preFilters = element.getChild("pre-filters", namespace);
            N2oPreFilter[] n2oPreFilters = PreFilterReaderV1Util.getControlPreFilterListDefinition(preFilters);
            if (n2oPreFilters != null) {
                showModal.setPreFilters(new N2oPreFilter[n2oPreFilters.length]);
                showModal.setPreFilters(n2oPreFilters);
            }
            showModal.setResultContainerId(ReaderJdomUtil.getAttributeString(element, "result-container-id"));
            showModal.setContainerId(ReaderJdomUtil.getAttributeString(element, "container-id"));
            showModal.setRefreshDependentContainer(ReaderJdomUtil.getAttributeBoolean(element, "refresh-dependent-container"));
            showModal.setMasterFieldId(ReaderJdomUtil.getAttributeString(element, "master-field-id"));
            showModal.setDetailFieldId(ReaderJdomUtil.getAttributeString(element, "detail-field-id"));
            showModal.setWidth(ReaderJdomUtil.getAttributeString(element, "width"));
            showModal.setMinWidth(ReaderJdomUtil.getAttributeString(element, "min-width"));
            showModal.setMaxWidth(ReaderJdomUtil.getAttributeString(element, "max-width"));
        }
        catch (Exception e) {
            throw new MetadataReaderException(e);
        }
    }

    public static void readEditFromActionId(Element element, N2oAbstractPageAction showModal) {
        AfterCancel afterCancel;
        String actionId = ReaderJdomUtil.getAttributeString(element, "action-id");
        if (actionId == null) {
            return;
        }
        showModal.setSubmitOperationId(actionId);
        FormModel model = ReaderJdomUtil.getAttributeEnum(element, "model", FormModel.class);
        if (model != null) {
            showModal.setUpload(model.getUpload());
        }
        showModal.setCreateMore(ReaderJdomUtil.getAttributeBoolean(element, "create-more"));
        showModal.setFocusAfterSubmit(ReaderJdomUtil.getAttributeBoolean(element, "focus-after-submit"));
        showModal.setRefreshOnClose(ReaderJdomUtil.getAttributeBoolean(element, "refresh-on-close"));
        AfterSubmit afterSubmit = ReaderJdomUtil.getAttributeEnum(element, "after-submit", AfterSubmit.class);
        if (afterSubmit != null) {
            if (afterSubmit.equals((Object)AfterSubmit.closeModal)) {
                showModal.setCloseAfterSubmit(Boolean.valueOf(true));
            } else if (afterSubmit.equals((Object)AfterSubmit.edit)) {
                showModal.setCloseAfterSubmit(Boolean.valueOf(false));
            } else {
                throw new UnsupportedOperationException("Unsupported since 7.0");
            }
        }
        if ((afterCancel = ReaderJdomUtil.getAttributeEnum(element, "after-cancel", AfterCancel.class)) != null) {
            throw new UnsupportedOperationException("Unsupported since 7.0");
        }
        Boolean refreshAfterSubmit = ReaderJdomUtil.getAttributeBoolean(element, "refresh-after-submit");
        if (refreshAfterSubmit != null && !refreshAfterSubmit.booleanValue()) {
            throw new UnsupportedOperationException("Unsupported since 7.0");
        }
    }
}

