/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.warmup;

import net.n2oapp.framework.api.event.N2oStartedEvent;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.metadata.compile.context.HeaderContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.reader.ReferentialIntegrityViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

public class HeaderWarmUpper
implements EnvironmentAware {
    private static Logger log = LoggerFactory.getLogger(HeaderWarmUpper.class);
    private Environment environment;
    private N2oApplicationBuilder applicationBuilder;

    @EventListener(value={N2oStartedEvent.class})
    public void warmUp() {
        String headerId = (String)this.environment.getProperty("n2o.header.id", String.class, null);
        String welcomePageId = (String)this.environment.getProperty("n2o.ui.homepage.id", String.class, null);
        ReadCompileTerminalPipeline pipeline = (ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)this.applicationBuilder.read().transform()).validate()).cache()).compile()).transform()).cache();
        if (headerId != null && !headerId.isEmpty()) {
            pipeline.get((CompileContext)new HeaderContext(headerId));
        } else if (welcomePageId != null && !welcomePageId.isEmpty()) {
            PageContext context = new PageContext(welcomePageId, "/");
            try {
                pipeline.get((CompileContext)context);
            }
            catch (ReferentialIntegrityViolationException ignore) {
                log.error("Main page by id " + welcomePageId + " not found ");
            }
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationBuilder(N2oApplicationBuilder applicationBuilder) {
        this.applicationBuilder = applicationBuilder;
    }
}

