/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.java;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import net.n2oapp.framework.api.data.ArgumentsInvocationEngine;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.dataprovider.DIProvider;
import net.n2oapp.framework.api.metadata.dataprovider.N2oJavaDataProvider;
import net.n2oapp.framework.engine.data.java.ObjectLocator;
import org.springframework.util.MethodInvoker;

public class JavaDataProviderEngine
implements ArgumentsInvocationEngine<N2oJavaDataProvider> {
    private List<ObjectLocator> locators = Collections.emptyList();

    public Class<? extends N2oJavaDataProvider> getType() {
        return N2oJavaDataProvider.class;
    }

    public Object invoke(N2oJavaDataProvider dataProvider, Object[] data) {
        Class<?> targetClass = this.findTargetClass(dataProvider);
        Object targetObject = null;
        if (dataProvider.getDiProvider() != null) {
            targetObject = this.match(dataProvider.getDiProvider()).locate(targetClass, dataProvider.getDiProvider());
        }
        return this.invokeMethod(targetClass, dataProvider.getMethod(), targetObject, data);
    }

    private Class<?> findTargetClass(N2oJavaDataProvider dataProvider) {
        if (dataProvider.getClassName() == null) {
            return null;
        }
        Class<?> targetClass = null;
        try {
            targetClass = Class.forName(dataProvider.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new N2oException((Throwable)e);
        }
        return targetClass;
    }

    private <T extends DIProvider> ObjectLocator<T> match(T provider) {
        return this.locators.stream().filter(l -> l.match(provider)).findAny().orElseThrow(() -> new IllegalArgumentException("No such data provider " + provider));
    }

    public void setLocators(List<ObjectLocator> locators) {
        this.locators = locators;
    }

    private Object invokeMethod(Class<?> targetClass, String method, Object targetObject, Object[] args) {
        MethodInvoker methodInvoker = new MethodInvoker();
        methodInvoker.setTargetClass(targetClass);
        methodInvoker.setTargetObject(targetObject);
        methodInvoker.setTargetMethod(method);
        methodInvoker.setArguments(args);
        try {
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException e) {
            throw new N2oException(e.getTargetException());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new N2oException((Throwable)e);
        }
    }
}

