/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oRestDataProvider;
import net.n2oapp.framework.engine.data.QueryUtil;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class SpringRestDataProviderEngine
implements MapInvocationEngine<N2oRestDataProvider> {
    private RestTemplate restTemplate;
    private ObjectMapper objectMapper;
    private ResponseExtractor<Object> responseExtractor;
    private String baseRestUrl;

    public SpringRestDataProviderEngine(RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.responseExtractor = new N2oResponseExtractor(objectMapper);
    }

    public Class<? extends N2oRestDataProvider> getType() {
        return N2oRestDataProvider.class;
    }

    public void setBaseRestUrl(String baseRestUrl) {
        this.baseRestUrl = baseRestUrl;
    }

    public Object invoke(N2oRestDataProvider invocation, Map<String, Object> data) {
        Object query = invocation.getQuery();
        if (query == null) {
            throw new N2oException("query mustn't be null");
        }
        query = ((String)query).trim();
        HttpMethod method = invocation.getMethod() == null ? HttpMethod.GET : HttpMethod.resolve((String)invocation.getMethod().name());
        HashMap<String, Object> args = new HashMap<String, Object>();
        data.forEach(args::put);
        if (!((String)query).contains("http")) {
            if (!((String)query).startsWith("/")) {
                query = "/" + (String)query;
            }
            if (((String)query).contains("//")) {
                query = ((String)query).replace("//", "/");
            }
            query = this.baseRestUrl + (String)query;
        }
        String filtersSeparator = invocation.getFiltersSeparator() != null ? invocation.getFiltersSeparator() : "&";
        String sortingSeparator = invocation.getSortingSeparator() != null ? invocation.getSortingSeparator() : "&";
        String joinSeparator = invocation.getJoinSeparator() != null ? invocation.getJoinSeparator() : "&";
        query = QueryUtil.replaceListPlaceholder((String)query, "{select}", args.remove("select"), "", (a, b) -> a + invocation.getSelectSeparator() + b);
        query = QueryUtil.replaceListPlaceholder((String)query, "{filters}", args.remove("filters"), "", str -> this.resolve((String)str, (Map<String, Object>)args, (a, b) -> a + filtersSeparator + b), (a, b) -> a + filtersSeparator + b);
        query = QueryUtil.replaceListPlaceholder((String)query, "{sorting}", args.remove("sorting"), "", (a, b) -> a + sortingSeparator + b);
        query = QueryUtil.replaceListPlaceholder((String)query, "{join}", args.remove("join"), "", (a, b) -> a + joinSeparator + b);
        query = QueryUtil.normalizeQueryParams((String)query);
        return this.executeQuery(method, (String)query, args, invocation.getProxyHost(), invocation.getProxyPort());
    }

    protected HttpHeaders initHeaders(Map<String, Object> args) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        return httpHeaders;
    }

    private Object executeQuery(HttpMethod method, String query, Map<String, Object> args, String proxyHost, Integer proxyPort) {
        query = SpringRestDataProviderEngine.getURL(proxyHost, proxyPort, query);
        HttpHeaders headers = this.initHeaders(args);
        HashMap<String, Object> body = new HashMap<String, Object>(args);
        switch (method) {
            case GET: {
                return this.exchange(query, method, headers, args);
            }
            case DELETE: 
            case POST: 
            case PUT: 
            case PATCH: {
                return this.exchange(query, method, body, headers, args);
            }
        }
        throw new UnsupportedOperationException("Method " + method.name() + " unsupported");
    }

    private Object exchange(String query, HttpMethod method, HttpHeaders headers, Map<String, Object> args) {
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback((Object)new HttpEntity((MultiValueMap)headers), Object.class);
        return this.restTemplate.execute(query, method, requestCallback, this.responseExtractor, args);
    }

    private Object exchange(String query, HttpMethod method, Object body, HttpHeaders headers, Map<String, Object> args) {
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback((Object)new HttpEntity(body, (MultiValueMap)headers), Object.class);
        return this.restTemplate.execute(query, method, requestCallback, this.responseExtractor, args);
    }

    private String resolve(String str, Map<String, Object> args, BinaryOperator<String> reducer) {
        if (!str.contains("{") || !str.contains("}")) {
            return str;
        }
        String paramKey = str.substring(str.indexOf(123) + 1, str.indexOf(125));
        if (!(args.get(paramKey) instanceof List)) {
            if (args.get(paramKey) == null) {
                return "";
            }
            args.put(paramKey, this.resolveType(str, args.get(paramKey)));
            return str;
        }
        List params = (List)args.get(paramKey);
        AtomicInteger i = new AtomicInteger();
        Optional<String> result = params.stream().map(item -> {
            if (item == null) {
                return "";
            }
            String newParamKey = paramKey + i.incrementAndGet();
            args.put(newParamKey, this.resolveType(str, item));
            return str.replace(Placeholders.ref((String)paramKey), Placeholders.ref((String)newParamKey));
        }).reduce(reducer);
        return result.orElse("");
    }

    private String resolveType(String target, Object value) {
        String result;
        if (value == null) {
            return target;
        }
        if (value instanceof String || value instanceof Boolean) {
            result = value.toString();
        } else {
            try {
                result = this.objectMapper.writeValueAsString(value).replace("\"", "");
            }
            catch (JsonProcessingException e) {
                throw new N2oException((Throwable)e);
            }
        }
        return result;
    }

    private static String getURL(String host, Integer port, String url) {
        if (host == null || port == null) {
            return url;
        }
        return "http://" + host + ":" + port + url;
    }

    private static class N2oResponseExtractor
    implements ResponseExtractor<Object> {
        private ObjectMapper mapper;

        public N2oResponseExtractor(ObjectMapper objectMapper) {
            this.mapper = objectMapper;
        }

        public Object extractData(ClientHttpResponse response) throws IOException {
            String result;
            try (InputStream body = response.getBody();){
                result = IOUtils.toString((InputStream)body, (Charset)StandardCharsets.UTF_8);
            }
            Object data = null;
            if (result != null && !result.isEmpty()) {
                data = (result = result.trim()).startsWith("[") ? this.mapper.readValue(result, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, DataSet.class)) : (result.startsWith("{") ? this.mapper.readValue(result, DataSet.class) : this.mapper.readValue(result, Object.class));
            }
            return data;
        }
    }
}

