/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.criteria.api.Sorting;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.DataSetMapper;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.data.CriteriaConstructor;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.Argument;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.engine.util.ClassHash;
import net.n2oapp.framework.engine.util.MappingProcessor;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class InvocationParametersMapping {
    public static Map<String, String> extractOutFieldMapping(Collection<ObjectSimpleField> parameters) {
        LinkedHashMap<String, String> mappingMap = new LinkedHashMap<String, String>();
        if (parameters != null) {
            for (ObjectSimpleField parameter : parameters) {
                mappingMap.put(parameter.getId(), parameter.getMapping());
            }
        }
        return mappingMap;
    }

    public static Map<String, FieldMapping> extractInFieldMapping(Collection<AbstractParameter> parameters) {
        LinkedHashMap<String, FieldMapping> mappingMap = new LinkedHashMap<String, FieldMapping>();
        if (parameters != null) {
            for (AbstractParameter parameter : parameters) {
                FieldMapping mapping = new FieldMapping(parameter.getMapping());
                if (parameter instanceof ObjectReferenceField && ((ObjectReferenceField)parameter).getFields() != null) {
                    mapping.setChildMapping(InvocationParametersMapping.extractInFieldMapping(Arrays.asList(((ObjectReferenceField)parameter).getFields())));
                }
                mappingMap.put(parameter.getId(), mapping);
            }
        }
        return mappingMap;
    }

    public static Object[] mapToArgs(N2oArgumentsInvocation invocation, DataSet inDataSet, Map<String, FieldMapping> inMapping, DomainProcessor domainProcessor) {
        inMapping = InvocationParametersMapping.changeInMappingForEntity(invocation, inMapping);
        if (invocation.getArguments() == null || invocation.getArguments().length == 0) {
            return null;
        }
        return MappingProcessor.map(inDataSet, inMapping, invocation.getArguments(), domainProcessor);
    }

    public static Map<String, Object> mapToMap(DataSet dataSet, Map<String, FieldMapping> mapping) {
        return DataSetMapper.mapToMap((DataSet)dataSet, mapping);
    }

    public static void prepareMapForQuery(Map<String, Object> map, CompiledQuery query, N2oPreparedCriteria criteria) {
        N2oQuery.Field field;
        map.put("select", query.getSelectExpressions());
        LinkedHashSet<String> joins = new LinkedHashSet<String>(query.getJoinExpressions());
        ArrayList<String> where = new ArrayList<String>();
        for (Restriction r : criteria.getRestrictions()) {
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(r.getFieldId())).get(r.getType());
            if (filter.getText() != null) {
                where.add(filter.getText());
            }
            MappingProcessor.inMap(map, filter.getMapping(), r.getValue());
            field = (N2oQuery.Field)query.getFieldsMap().get(r.getFieldId());
            if (field.getNoJoin().booleanValue()) continue;
            joins.add(field.getJoinBody());
        }
        map.put("filters", where);
        ArrayList<String> sortingExp = new ArrayList<String>();
        if (criteria.getSorting() != null) {
            for (Sorting sorting : criteria.getSortings()) {
                field = (N2oQuery.Field)query.getFieldsMap().get(sorting.getField());
                if (field.getNoSorting().booleanValue()) continue;
                sortingExp.add(field.getSortingBody());
                MappingProcessor.inMap(map, field.getSortingMapping(), sorting.getDirection().getExpression());
                if (field.getNoJoin().booleanValue()) continue;
                joins.add(field.getJoinBody());
            }
        }
        map.put("sorting", sortingExp);
        if (criteria.getAdditionalFields() != null) {
            criteria.getAdditionalFields().entrySet().stream().filter(es -> es.getValue() != null).forEach(es -> map.put((String)es.getKey(), es.getValue()));
        }
        map.put("join", new ArrayList(joins));
    }

    public static void prepareMapForPage(Map<String, Object> map, N2oPreparedCriteria criteria, boolean pageStartsWith0) {
        map.put("limit", criteria.getSize());
        map.put("offset", criteria.getFirst());
        if (criteria.getCount() != null) {
            map.put("count", criteria.getCount());
        }
        map.put("page", pageStartsWith0 ? criteria.getPage() - 1 : criteria.getPage());
    }

    public static Object[] prepareArgsForQuery(N2oArgumentsInvocation invocation, CompiledQuery query, N2oPreparedCriteria criteria, CriteriaConstructor criteriaConstructor, DomainProcessor domainProcessor) {
        Class<?>[] classesOfArguments = InvocationParametersMapping.takeClassesOfArguments(invocation);
        if (classesOfArguments == null || classesOfArguments.length == 0) {
            return new Object[0];
        }
        Object[] argumentInstances = new Object[classesOfArguments.length];
        int criteriaIdx = -1;
        for (int i = 0; i < invocation.getArguments().length; ++i) {
            if (classesOfArguments[i] == null) continue;
            if (invocation.getArguments()[i].getType().equals((Object)Argument.Type.CLASS) || invocation.getArguments()[i].getType().equals((Object)Argument.Type.ENTITY)) {
                try {
                    argumentInstances[i] = classesOfArguments[i].newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(classesOfArguments[i].getName(), e);
                }
            }
            if (!invocation.getArguments()[i].getType().equals((Object)Argument.Type.CRITERIA)) continue;
            argumentInstances[i] = criteriaConstructor.construct(criteria, classesOfArguments[i]);
            criteriaIdx = i;
        }
        if (Arrays.stream(invocation.getArguments()).filter(arg -> arg.getType().equals((Object)Argument.Type.ENTITY) || arg.getType().equals((Object)Argument.Type.CRITERIA)).collect(Collectors.toList()).size() > 1) {
            throw new IllegalArgumentException("There must be only one argument with Criteria or Entity type ");
        }
        for (Restriction r : criteria.getRestrictions()) {
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(r.getFieldId())).get(r.getType());
            String mapping = filter.getMapping().startsWith("[") ? filter.getMapping() : "[" + criteriaIdx + "]." + filter.getMapping();
            MappingProcessor.inMap(argumentInstances, mapping, r.getValue());
        }
        for (int i = 0; i < argumentInstances.length; ++i) {
            String defaultValue = invocation.getArguments()[i].getDefaultValue();
            if (argumentInstances[i] != null || defaultValue == null) continue;
            argumentInstances[i] = domainProcessor.deserialize((Object)defaultValue);
        }
        return argumentInstances;
    }

    private static Map<String, FieldMapping> changeInMappingForEntity(N2oArgumentsInvocation invocation, Map<String, FieldMapping> inMapping) {
        if (ArrayUtils.isEmpty((Object[])invocation.getArguments())) {
            int[] idx = new int[]{0};
            HashMap<String, FieldMapping> newMap = new HashMap<String, FieldMapping>();
            inMapping.forEach((k, v) -> {
                String string;
                if (v.getMapping() != null) {
                    string = v.getMapping();
                } else {
                    Object[] objectArray = new Object[1];
                    int n = idx[0];
                    idx[0] = n + 1;
                    objectArray[0] = n;
                    string = String.format("[%s]", objectArray);
                }
                String mapping = string;
                FieldMapping fieldMapping = new FieldMapping(mapping);
                fieldMapping.setChildMapping(v.getChildMapping());
                newMap.put((String)k, fieldMapping);
            });
            inMapping = newMap;
        } else {
            int entityPosition = InvocationParametersMapping.findEntityPosition(invocation);
            if (entityPosition != -1) {
                String prefix = "[" + entityPosition + "].";
                for (String key : inMapping.keySet()) {
                    String value;
                    if (inMapping.get(key) == null || (value = inMapping.get(key).getMapping()) == null || value.startsWith("[")) continue;
                    inMapping.get(key).setMapping(prefix + value);
                }
            }
        }
        return inMapping;
    }

    public static Object normalizeValue(Object value, String normalizer, DataSet allData, ExpressionParser parser, BeanFactory beanFactory) {
        if (normalizer == null) {
            return value;
        }
        StandardEvaluationContext context = new StandardEvaluationContext(value);
        if (allData != null) {
            context.setVariable("data", (Object)allData);
        }
        if (beanFactory != null) {
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        Expression exp = parser.parseExpression(normalizer);
        return exp.getValue((EvaluationContext)context);
    }

    private static int findEntityPosition(N2oArgumentsInvocation invocation) {
        for (int i = 0; i < invocation.getArguments().length; ++i) {
            if (invocation.getArguments()[i].getType() == null || !invocation.getArguments()[i].getType().equals((Object)Argument.Type.ENTITY)) continue;
            return i;
        }
        return -1;
    }

    private static Class<?>[] takeClassesOfArguments(N2oArgumentsInvocation invocation) {
        int argumentCount = invocation.getArguments() != null ? invocation.getArguments().length : 0;
        Class[] classesOfArguments = new Class[argumentCount];
        if (invocation.getArguments() == null) {
            return null;
        }
        try {
            for (int i = 0; i < argumentCount; ++i) {
                classesOfArguments[i] = invocation.getArguments()[i].getClassName() == null || invocation.getArguments()[i].getType().equals((Object)Argument.Type.PRIMITIVE) ? null : ClassHash.getClass(invocation.getArguments()[i].getClassName());
            }
        }
        catch (Exception e) {
            throw new N2oException("Class of argument not found", (Throwable)e);
        }
        return classesOfArguments;
    }
}

