/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.Argument;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectListField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class MappingProcessor {
    private static final ExpressionParser writeParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final ExpressionParser readParser = new SpelExpressionParser(new SpelParserConfiguration(false, false));
    private static final Set<String> primitiveTypes = Stream.of("java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.util.Date", "java.math.BigDecimal").collect(Collectors.toSet());

    public static void inMap(Object target, String mapping, Object value) {
        Expression expression = writeParser.parseExpression(mapping);
        if (target != null) {
            expression.setValue(target, value);
        }
    }

    public static <T> T outMap(Object target, String mapping, Class<T> clazz) {
        Object result;
        if (mapping != null) {
            Expression expression = readParser.parseExpression(mapping);
            result = expression.getValue(target, clazz);
        } else {
            result = target;
        }
        if (clazz != null && result == null) {
            throw new N2oException("Expected is " + clazz + ", but actual is null");
        }
        if (clazz != null && !clazz.isAssignableFrom(result.getClass())) {
            throw new N2oException("Expected is " + clazz + ", but actual is " + result.getClass());
        }
        return (T)result;
    }

    public static void outMap(DataSet target, Object value, String fieldId, String mapping, Object defaultValue, ContextProcessor contextProcessor) {
        Expression expression = readParser.parseExpression(mapping);
        Object obj = expression.getValue(value);
        target.put(fieldId, obj == null ? contextProcessor.resolve(defaultValue) : obj);
    }

    public static Object[] map(DataSet dataSet, Map<String, FieldMapping> mappingMap, Argument[] arguments, DomainProcessor domainProcessor) {
        ArrayList<String> argClasses = new ArrayList<String>();
        for (Argument arg : arguments) {
            argClasses.add(arg.getClassName());
        }
        Object[] instances = MappingProcessor.instantiateArguments(argClasses);
        Object[] result = ArrayUtils.isEmpty((Object[])instances) ? new Object[mappingMap.size()] : instances;
        boolean hasOnlyOneEntity = result.length == 1 && result[0] != null;
        int idx = 0;
        for (Map.Entry<String, FieldMapping> map : mappingMap.entrySet()) {
            Object value = dataSet.get((Object)map.getKey());
            String mapping = map.getValue().getMapping();
            if (mapping != null && !mapping.startsWith("[") && !mapping.endsWith("]") || value != null) {
                Object resultMapping = mapping;
                if (resultMapping == null) {
                    resultMapping = hasOnlyOneEntity ? "[0]." + map.getKey() : "[" + idx + "]";
                }
                Expression expression = writeParser.parseExpression((String)resultMapping);
                expression.setValue((Object)result, value);
            }
            ++idx;
        }
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != null || arguments[i].getDefaultValue() == null) continue;
            result[i] = domainProcessor.deserialize((Object)arguments[i].getDefaultValue());
        }
        return result;
    }

    private static Object[] instantiateArguments(List<String> arguments) {
        if (arguments == null) {
            return null;
        }
        Object[] argumentInstances = new Object[arguments.size()];
        for (int k = 0; k < arguments.size(); ++k) {
            if (arguments.get(k) == null || primitiveTypes.contains(arguments.get(k))) {
                argumentInstances[k] = null;
                continue;
            }
            try {
                Class<?> argumentClass = Class.forName(arguments.get(k));
                argumentInstances[k] = argumentClass.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new N2oException("Can't create instance of class " + arguments.get(k), (Throwable)e);
            }
        }
        return argumentInstances;
    }

    public static void mapParameter(ObjectReferenceField parameter, DataSet dataSet) {
        Object data = dataSet.get((Object)parameter.getId());
        if (data == null) {
            return;
        }
        if (parameter.getClass().equals(ObjectReferenceField.class)) {
            dataSet.put(parameter.getId(), MappingProcessor.mapChildParameters(parameter, (DataSet)data));
        } else {
            AbstractCollection collection = parameter instanceof ObjectListField ? new ArrayList() : new HashSet();
            for (Object item : (Collection)data) {
                collection.add(MappingProcessor.mapChildParameters(parameter, (DataSet)item));
            }
            dataSet.put(parameter.getId(), collection);
        }
    }

    public static Object mapChildParameters(ObjectReferenceField parameter, DataSet dataSet) {
        Object instance;
        try {
            instance = Class.forName(parameter.getEntityClass()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new N2oException((Throwable)e);
        }
        for (AbstractParameter childParam : parameter.getFields()) {
            String target = childParam.getMapping() != null ? childParam.getMapping() : childParam.getId();
            writeParser.parseExpression(target).setValue(instance, dataSet.get((Object)childParam.getId()));
        }
        return instance;
    }
}

