/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.validation.engine.info;

import java.util.Collections;
import java.util.List;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.engine.validation.engine.ValidationUtil;

public class FieldsValidationInfo {
    private CompiledObject object;
    private List<CompiledObject.Operation> operations;
    private DataSet dataSet;
    private List<Validation> visibleValidations;
    private String messageForm;

    public FieldsValidationInfo(CompiledObject object, CompiledObject.Operation action, DataSet dataSet, String messageForm) {
        this.object = object;
        this.operations = Collections.singletonList(action);
        this.dataSet = dataSet;
        this.visibleValidations = ValidationUtil.calculateVisibleValidation(object.getFieldValidations(), dataSet);
        this.messageForm = messageForm;
    }

    public FieldsValidationInfo(CompiledObject object, DataSet dataSet, String messageForm) {
        this.object = object;
        this.operations = Collections.emptyList();
        this.dataSet = dataSet;
        this.visibleValidations = ValidationUtil.calculateVisibleValidation(object.getFieldValidations(), dataSet);
        this.messageForm = messageForm;
    }

    public CompiledObject getObject() {
        return this.object;
    }

    public List<CompiledObject.Operation> getOperations() {
        return this.operations;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public List<Validation> getVisibleValidations() {
        return this.visibleValidations;
    }

    public String getMessageForm() {
        return this.messageForm;
    }
}

