/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.auth.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.n2oapp.security.admin.api.model.UserDetailsToken;
import net.n2oapp.security.admin.api.service.UserDetailsService;
import net.n2oapp.security.auth.common.User;
import net.n2oapp.security.auth.common.authority.PermissionGrantedAuthority;
import net.n2oapp.security.auth.common.authority.RoleGrantedAuthority;
import net.n2oapp.security.auth.common.authority.SystemGrantedAuthority;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class AuthoritiesPrincipalExtractor
implements PrincipalExtractor,
AuthoritiesExtractor {
    private static final String GRANTED_AUTHORITY_KEY = "GrantedAuthorityKey";
    private String[] PRINCIPAL_KEYS = new String[]{"username", "preferred_username", "login", "sub"};
    private static final String[] SURNAME_KEYS = new String[]{"surname", "second_name", "family_name", "lastName"};
    private static final String[] NAME_KEYS = new String[]{"first_name", "given_name", "name", "firstName"};
    private static final String[] PATRONYMIC_KEYS = new String[]{"middleName"};
    private static final String[] EMAIL_KEYS = new String[]{"email", "e-mail", "mail"};
    private static final String[] GUID_KEYS = new String[]{"sub", "oid"};
    private static final String[] AUTHORITIES_KEYS = new String[]{"roles", "authorities", "realm_access.roles", "resource_access.roles"};
    private final UserDetailsService userDetailsService;
    private final String externalSystem;

    public AuthoritiesPrincipalExtractor(UserDetailsService userDetailsService, String externalSystem) {
        this.userDetailsService = userDetailsService;
        this.externalSystem = externalSystem;
    }

    public Object extractPrincipal(Map<String, Object> map) {
        net.n2oapp.security.admin.api.model.User model = this.getUser(map);
        if (model == null) {
            return null;
        }
        User user = new User(model.getUsername(), "N/A", this.getAuthorities(map, model), model.getSurname(), model.getName(), model.getPatronymic(), model.getEmail());
        if (Objects.nonNull(model.getDepartment())) {
            user.setDepartment(model.getDepartment().getCode());
            user.setDepartmentName(model.getDepartment().getName());
        }
        if (Objects.nonNull(model.getOrganization())) {
            user.setOrganization(model.getOrganization().getCode());
        }
        if (Objects.nonNull(model.getRegion())) {
            user.setRegion(model.getRegion().getCode());
        }
        if (Objects.nonNull(model.getUserLevel())) {
            user.setUserLevel(model.getUserLevel().toString());
        }
        return user;
    }

    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        return this.getAuthorities(map, null);
    }

    public AuthoritiesPrincipalExtractor setPrincipalKeys(String ... pKeys) {
        this.PRINCIPAL_KEYS = pKeys;
        return this;
    }

    private net.n2oapp.security.admin.api.model.User getUser(Map<String, Object> map) {
        Object usernameObj = this.extractFromMap(this.PRINCIPAL_KEYS, map);
        if (usernameObj == null) {
            return null;
        }
        Object roles = this.extractFromMap(AUTHORITIES_KEYS, map);
        ArrayList roleList = new ArrayList();
        if (roles instanceof Collection) {
            roleList = new ArrayList((Collection)roles);
        }
        String username = (String)usernameObj;
        String surname = this.extractFromMap(SURNAME_KEYS, map) == null ? null : (String)this.extractFromMap(SURNAME_KEYS, map);
        String name = this.extractFromMap(NAME_KEYS, map) == null ? null : (String)this.extractFromMap(NAME_KEYS, map);
        String email = this.extractFromMap(EMAIL_KEYS, map) == null ? null : (String)this.extractFromMap(EMAIL_KEYS, map);
        String patronymic = this.extractFromMap(PATRONYMIC_KEYS, map) == null ? null : (String)this.extractFromMap(PATRONYMIC_KEYS, map);
        UserDetailsToken token = new UserDetailsToken();
        token.setUsername(username);
        token.setRoleNames(roleList);
        token.setExtUid((String)this.extractFromMap(GUID_KEYS, map));
        token.setName(name);
        token.setSurname(surname);
        token.setPatronymic(patronymic);
        token.setEmail(email);
        token.setExternalSystem(this.externalSystem);
        net.n2oapp.security.admin.api.model.User user = this.userDetailsService.loadUserDetails(token);
        map.put("system", this.externalSystem);
        return user;
    }

    private List<GrantedAuthority> getAuthorities(Map<String, Object> map, net.n2oapp.security.admin.api.model.User user) {
        if (map.containsKey(GRANTED_AUTHORITY_KEY)) {
            return (List)map.get(GRANTED_AUTHORITY_KEY);
        }
        if (user == null) {
            user = this.getUser(map);
        }
        List<Object> authorities = new ArrayList<GrantedAuthority>();
        if (Objects.nonNull(user) && Objects.nonNull(user.getRoles())) {
            authorities.addAll(user.getRoles().stream().map(r -> new RoleGrantedAuthority(r.getCode())).collect(Collectors.toList()));
            authorities.addAll(user.getRoles().stream().filter(r -> Objects.nonNull(r.getPermissions())).flatMap(r -> r.getPermissions().stream()).map(p -> new PermissionGrantedAuthority(p.getCode())).collect(Collectors.toList()));
            authorities.addAll(user.getRoles().stream().filter(role -> Objects.nonNull(role.getSystem())).map(role -> new SystemGrantedAuthority(role.getSystem().getCode())).collect(Collectors.toList()));
            authorities.addAll(user.getRoles().stream().filter(r -> Objects.nonNull(r.getPermissions())).flatMap(r -> r.getPermissions().stream()).filter(permission -> Objects.nonNull(permission.getSystem())).map(p -> new SystemGrantedAuthority(p.getSystem().getCode())).collect(Collectors.toList()));
            authorities = authorities.stream().distinct().collect(Collectors.toList());
            map.put(GRANTED_AUTHORITY_KEY, authorities);
        }
        return authorities;
    }

    private Object extractFromMap(String[] keys, Map<String, Object> map) {
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }
}

