/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.auth.common;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.n2oapp.security.auth.common.authority.PermissionGrantedAuthority;
import net.n2oapp.security.auth.common.authority.RoleGrantedAuthority;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.StringUtils;

public class User
extends org.springframework.security.core.userdetails.User {
    private static final String DEFAULT_ROLE = "ROLE_USER";
    private String surname;
    private String name;
    private String patronymic;
    private String email;
    private String organization;
    private String region;
    private String department;
    private String departmentName;
    private String userLevel;

    public User(String username) {
        super(username, "", Collections.singleton(new RoleGrantedAuthority(DEFAULT_ROLE)));
    }

    public User(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, authorities);
    }

    public User(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }

    public User(String username, String password, Collection<? extends GrantedAuthority> authorities, String surname, String name, String patronymic, String email) {
        super(username, password, authorities);
        this.surname = surname;
        this.name = name;
        this.patronymic = patronymic;
        this.email = email;
    }

    public User(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities, String surname, String name, String patronymic, String email) {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        this.surname = surname;
        this.name = name;
        this.patronymic = patronymic;
        this.email = email;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getName() {
        return this.name;
    }

    public String getUserFullName() {
        LinkedList<String> fullNameParts = new LinkedList<String>();
        if (!StringUtils.isEmpty((Object)this.surname)) {
            fullNameParts.add(this.surname);
        }
        if (!StringUtils.isEmpty((Object)this.name)) {
            fullNameParts.add(this.name);
        }
        if (!StringUtils.isEmpty((Object)this.patronymic)) {
            fullNameParts.add(this.patronymic);
        }
        if (fullNameParts.isEmpty()) {
            fullNameParts.add(this.getUsername());
        }
        return String.join((CharSequence)" ", fullNameParts);
    }

    public String getUserShortName() {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((Object)this.surname)) {
            sb.append(this.getSurname().trim()).append(' ');
            if (!StringUtils.isEmpty((Object)this.name)) {
                sb.append(this.name.trim().toUpperCase().charAt(0)).append('.');
            }
            if (!StringUtils.isEmpty((Object)this.patronymic)) {
                sb.append(this.patronymic.trim().toUpperCase().charAt(0)).append('.');
            }
        } else if (!StringUtils.isEmpty((Object)this.name)) {
            sb.append(this.getName().trim());
        } else {
            sb.append(this.getUsername()).append(' ');
        }
        return sb.toString();
    }

    public String getUserNameSurname() {
        LinkedList<String> parts = new LinkedList<String>();
        if (!StringUtils.isEmpty((Object)this.name)) {
            parts.add(this.name);
        }
        if (!StringUtils.isEmpty((Object)this.surname)) {
            parts.add(this.surname);
        }
        if (parts.isEmpty()) {
            parts.add(this.getUsername());
        }
        return String.join((CharSequence)" ", parts);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPatronymic() {
        return this.patronymic;
    }

    public void setPatronymic(String patronymic) {
        this.patronymic = patronymic;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getUserLevel() {
        return this.userLevel;
    }

    public void setUserLevel(String userLevel) {
        this.userLevel = userLevel;
    }

    public List<String> getRoles() {
        return this.getAuthorities().stream().filter(a -> a instanceof RoleGrantedAuthority).map(a -> ((RoleGrantedAuthority)a).getRole()).collect(Collectors.toList());
    }

    public List<String> getPermissions() {
        return this.getAuthorities().stream().filter(a -> a instanceof PermissionGrantedAuthority).map(p -> ((PermissionGrantedAuthority)p).getPermission()).collect(Collectors.toList());
    }
}

