/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.auth.common;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.security.auth.common.authority.PermissionGrantedAuthority;
import net.n2oapp.security.auth.common.authority.RoleGrantedAuthority;
import net.n2oapp.security.auth.common.authority.SystemGrantedAuthority;
import org.springframework.beans.BeanUtils;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class UserParamsUtil {
    private static final String ROLES = "roles";
    private static final String PERMISSIONS = "permissions";
    private static final String SYSTEMS = "systems";

    public static String getSessionId() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return "";
        }
        return UserParamsUtil.getSessionId(context.getAuthentication());
    }

    public static String getSessionId(Authentication authentication) {
        if (authentication == null) {
            return "";
        }
        if (authentication.getDetails() instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails sessionDetails = (WebAuthenticationDetails)authentication.getDetails();
            return sessionDetails.getSessionId();
        }
        String sessionId = (String)UserParamsUtil.getProperty(authentication, BeanUtils.getPropertyDescriptor(authentication.getClass(), (String)"sessionId"));
        return sessionId == null ? "" : sessionId;
    }

    public static String getUsername() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return "";
        }
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            return "";
        }
        if (authentication instanceof AnonymousAuthenticationToken) {
            return "";
        }
        return UserParamsUtil.getUsername(authentication.getPrincipal());
    }

    public static String getUsername(Object principal) {
        String username = "";
        if (principal instanceof String) {
            username = (String)principal;
        } else if (principal instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)principal;
            username = userDetails.getUsername();
        }
        return username;
    }

    public static <T extends UserDetails> T getUserDetails() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return null;
        }
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object details = authentication.getPrincipal();
        if (details instanceof UserDetails) {
            return (T)((UserDetails)details);
        }
        details = authentication.getDetails();
        if (details instanceof UserDetails) {
            return (T)((UserDetails)details);
        }
        return null;
    }

    public static <T extends UserDetails> Map<String, Object> getUserDetailsAsMap(T userDetails) {
        if (userDetails == null) {
            return Collections.emptyMap();
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(userDetails.getClass());
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), UserParamsUtil.getProperty(userDetails, propertyDescriptor));
        }
        return map;
    }

    public static Map<String, Object> getUserDetailsAsMap() {
        return UserParamsUtil.getUserDetailsAsMap(UserParamsUtil.getUserDetails());
    }

    public static <T, U extends UserDetails> T getUserDetailsProperty(U userDetails, String property) {
        if (userDetails == null) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(userDetails.getClass(), (String)property);
        return UserParamsUtil.getProperty(userDetails, propertyDescriptor);
    }

    public static <T> T getUserDetailsProperty(String property) {
        return UserParamsUtil.getUserDetailsProperty(UserParamsUtil.getUserDetails(), property);
    }

    private static <T> T getProperty(Object bean, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            return null;
        }
        Method readMethod = propertyDescriptor.getReadMethod();
        if (readMethod == null) {
            return null;
        }
        try {
            return (T)readMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<GrantedAuthority> extractAuthorities(Map<String, ?> map) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (map.containsKey(ROLES)) {
            for (String role : (List)map.get(ROLES)) {
                authorities.add(new RoleGrantedAuthority(role));
            }
        }
        if (map.containsKey(PERMISSIONS)) {
            for (String permission : (List)map.get(PERMISSIONS)) {
                authorities.add(new PermissionGrantedAuthority(permission));
            }
        }
        if (map.containsKey(SYSTEMS)) {
            for (String system : (List)map.get(SYSTEMS)) {
                authorities.add(new SystemGrantedAuthority(system));
            }
        }
        return authorities;
    }
}

