/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.auth.common.authority;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class RoleGrantedAuthority
implements GrantedAuthority {
    private static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    private final String role;

    public RoleGrantedAuthority(String role) {
        Assert.hasText((String)role, (String)"A granted authority textual representation is required");
        this.role = role;
    }

    public String getAuthority() {
        return DEFAULT_ROLE_PREFIX + this.role;
    }

    public String getRole() {
        return this.role;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RoleGrantedAuthority) {
            return this.role.equals(((RoleGrantedAuthority)obj).role);
        }
        return false;
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public String toString() {
        return this.role;
    }
}

