/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.security.auth.common.authority;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class SystemGrantedAuthority
implements GrantedAuthority {
    private static final String DEFAULT_SYSTEM_PREFIX = "SYSTEM_";
    private final String system;

    public SystemGrantedAuthority(String system) {
        Assert.hasText((String)system, (String)"A granted authority textual representation is required");
        this.system = system;
    }

    public String getAuthority() {
        return DEFAULT_SYSTEM_PREFIX + this.system;
    }

    public String getSystem() {
        return this.system;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SystemGrantedAuthority) {
            return this.system.equals(((SystemGrantedAuthority)obj).system);
        }
        return false;
    }

    public int hashCode() {
        return this.system.hashCode();
    }

    public String toString() {
        return this.system;
    }
}

