/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueIn {
    public static final Consumer<ValueIn> DISCARD = v -> {};

    default public <T> WireIn text(T t, @NotNull BiConsumer<T, String> ts) {
        ts.accept(t, this.text());
        return this.wireIn();
    }

    default public WireIn text(@NotNull StringBuilder sb) {
        if (this.textTo(sb) == null) {
            sb.setLength(0);
        }
        return this.wireIn();
    }

    default public WireIn text(@NotNull Bytes sdo) {
        sdo.clear();
        this.textTo(sdo);
        return this.wireIn();
    }

    @Nullable
    public String text();

    @Nullable
    public StringBuilder textTo(@NotNull StringBuilder var1);

    @Nullable
    public Bytes textTo(@NotNull Bytes var1);

    @NotNull
    public WireIn bytes(@NotNull Bytes<?> var1);

    @NotNull
    public WireIn bytesMatch(@NotNull BytesStore var1, BooleanConsumer var2);

    @NotNull
    public WireIn bytes(@NotNull ReadMarshallable var1);

    @Nullable
    public byte[] bytes();

    @Nullable
    default public BytesStore bytesStore() {
        byte[] bytes = this.bytes();
        return bytes == null ? null : BytesStore.wrap((byte[])bytes);
    }

    @NotNull
    public WireIn wireIn();

    public long readLength();

    @NotNull
    public <T> WireIn bool(T var1, @NotNull ObjBooleanConsumer<T> var2);

    @NotNull
    public <T> WireIn int8(@NotNull T var1, @NotNull ObjByteConsumer<T> var2);

    @NotNull
    public <T> WireIn uint8(@NotNull T var1, @NotNull ObjShortConsumer<T> var2);

    @NotNull
    public <T> WireIn int16(@NotNull T var1, @NotNull ObjShortConsumer<T> var2);

    @NotNull
    public <T> WireIn uint16(@NotNull T var1, @NotNull ObjIntConsumer<T> var2);

    @NotNull
    public <T> WireIn int32(@NotNull T var1, @NotNull ObjIntConsumer<T> var2);

    @NotNull
    public <T> WireIn uint32(@NotNull T var1, @NotNull ObjLongConsumer<T> var2);

    @NotNull
    public <T> WireIn int64(@NotNull T var1, @NotNull ObjLongConsumer<T> var2);

    @NotNull
    public <T> WireIn float32(@NotNull T var1, @NotNull ObjFloatConsumer<T> var2);

    @NotNull
    public <T> WireIn float64(@NotNull T var1, @NotNull ObjDoubleConsumer<T> var2);

    @NotNull
    public <T> WireIn time(@NotNull T var1, @NotNull BiConsumer<T, LocalTime> var2);

    @NotNull
    public <T> WireIn zonedDateTime(@NotNull T var1, @NotNull BiConsumer<T, ZonedDateTime> var2);

    @NotNull
    public <T> WireIn date(@NotNull T var1, @NotNull BiConsumer<T, LocalDate> var2);

    public boolean hasNext();

    public boolean hasNextSequenceItem();

    @NotNull
    public <T> WireIn uuid(@NotNull T var1, @NotNull BiConsumer<T, UUID> var2);

    @NotNull
    public <T> WireIn int64array(@Nullable LongArrayValues var1, T var2, @NotNull BiConsumer<T, LongArrayValues> var3);

    @NotNull
    public WireIn int64(@Nullable LongValue var1);

    @NotNull
    public <T> WireIn int64(@Nullable LongValue var1, T var2, @NotNull BiConsumer<T, LongValue> var3);

    @NotNull
    public <T> WireIn int32(@Nullable IntValue var1, T var2, @NotNull BiConsumer<T, IntValue> var3);

    @NotNull
    public <T> WireIn sequence(@NotNull T var1, @NotNull BiConsumer<T, ValueIn> var2);

    public <T> T applyToMarshallable(Function<WireIn, T> var1);

    @Nullable
    public <T extends ReadMarshallable> T typedMarshallable() throws IORuntimeException;

    @NotNull
    public <T> ValueIn typePrefix(T var1, @NotNull BiConsumer<T, CharSequence> var2);

    @NotNull
    public <T> WireIn typeLiteralAsText(T var1, @NotNull BiConsumer<T, CharSequence> var2) throws IORuntimeException, BufferUnderflowException;

    @NotNull
    default public <T> WireIn typeLiteral(T t, @NotNull BiConsumer<T, Class> classConsumer) throws IORuntimeException {
        return this.typeLiteralAsText(t, (o, x) -> {
            try {
                classConsumer.accept(o, ClassAliasPool.CLASS_ALIASES.forName(x));
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
        });
    }

    @NotNull
    default public <T> WireIn typeLiteral(T t, @NotNull BiConsumer<T, Class> classConsumer, Class defaultClass) {
        return this.typeLiteralAsText(t, (o, x) -> {
            Class u = defaultClass;
            try {
                u = ClassAliasPool.CLASS_ALIASES.forName(x);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            classConsumer.accept(o, u);
        });
    }

    @NotNull
    public WireIn marshallable(@NotNull ReadMarshallable var1) throws BufferUnderflowException, IORuntimeException;

    default public void map(@NotNull Map<String, String> usingMap) {
        this.map(String.class, String.class, usingMap);
    }

    public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> var1);

    @Nullable
    public <K, V> Map<K, V> map(@NotNull Class<K> var1, @NotNull Class<V> var2, @NotNull Map<K, V> var3);

    public boolean bool() throws IORuntimeException;

    public byte int8();

    public short int16();

    public int uint16();

    public int int32();

    public long int64();

    public double float64();

    public float float32();

    public Class typeLiteral() throws IORuntimeException, BufferUnderflowException;

    default public Throwable throwable(boolean appendCurrentStack) {
        return WireInternal.throwable(this, appendCurrentStack);
    }

    default public <E extends Enum<E>> E asEnum(Class<E> eClass) {
        StringBuilder sb = WireInternal.acquireStringBuilder();
        this.text(sb);
        return sb.length() == 0 ? null : (E)WireInternal.internEnum(eClass, sb);
    }

    default public <E extends Enum<E>> WireIn asEnum(Class<E> eClass, Consumer<E> eConsumer) {
        eConsumer.accept(this.asEnum(eClass));
        return this.wireIn();
    }

    default public <E extends Enum<E>, T> WireIn asEnum(Class<E> eClass, T t, BiConsumer<T, E> teConsumer) {
        teConsumer.accept(t, this.asEnum(eClass));
        return this.wireIn();
    }

    @Nullable
    default public <E> E object(@NotNull Class<E> clazz) {
        return this.object(null, clazz);
    }

    @Nullable
    public <E> E object(@Nullable E var1, @NotNull Class<E> var2);

    @Nullable
    public <T, E> WireIn object(@NotNull Class<E> var1, T var2, BiConsumer<T, E> var3);

    default public WireIn decompress(Bytes bytes) {
        throw new UnsupportedOperationException();
    }

    public boolean isTyped();

    public Class typePrefix();
}

