/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodWriterInvocationHandler;

public class MethodWriterBuilder<T>
implements Supplier<T> {
    private final List<Class> interfaces = new ArrayList<Class>();
    private final MethodWriterInvocationHandler handler;
    private ClassLoader classLoader;

    public MethodWriterBuilder(MarshallableOut out, Class<T> tClass) {
        this.interfaces.add(Closeable.class);
        this.interfaces.add(tClass);
        this.handler = new MethodWriterInvocationHandler(out);
        this.classLoader = tClass.getClassLoader();
    }

    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public MethodWriterBuilder<T> addInterface(Class additionalClass) {
        this.interfaces.add(additionalClass);
        return this;
    }

    public MethodWriterBuilder<T> recordHistory(boolean recordHistory) {
        this.handler.recordHistory(recordHistory);
        return this;
    }

    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.handler.onClose(closeable);
        return this;
    }

    @Override
    public T get() {
        Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)this.handler);
    }
}

