/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.drmemory;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.praqma.drmemory.DrMemoryResult;
import net.praqma.jenkins.plugin.drmemory.DrMemoryBuilder;
import net.praqma.jenkins.plugin.drmemory.DrMemoryPublisher;
import net.praqma.jenkins.plugin.drmemory.graphs.AbstractGraph;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DrMemoryBuildAction
implements Action {
    private static final Logger logger = Logger.getLogger(DrMemoryBuildAction.class.getName());
    private DrMemoryResult result;
    private final AbstractBuild<?, ?> build;
    private DrMemoryPublisher publisher;
    private DrMemoryBuilder builder;

    public DrMemoryBuildAction(AbstractBuild<?, ?> build, DrMemoryBuilder builder) {
        this.build = build;
        this.builder = builder;
    }

    public void setPublisher(DrMemoryPublisher publisher) {
        this.publisher = publisher;
    }

    public DrMemoryPublisher getPublisher() {
        return this.publisher;
    }

    public void setResult(DrMemoryResult result) {
        this.result = result;
    }

    public DrMemoryBuilder getBuilder() {
        return this.builder;
    }

    public String getDisplayName() {
        return "DrMemory";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "drmemory";
    }

    public DrMemoryResult getResult() {
        return this.result;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        File dm = new File(this.build.getRootDir(), "drmemory.txt");
        Calendar t = this.build.getTimestamp();
        if (dm.exists()) {
            rsp.serveFile(req, (InputStream)FileUtils.openInputStream((File)dm), t.getTimeInMillis(), dm.getTotalSpace(), "drmemory.txt");
        } else {
            rsp.sendError(204);
        }
    }

    static DrMemoryBuildAction getPreviousResult(AbstractBuild<?, ?> start) {
        DrMemoryBuildAction r;
        AbstractBuild b = start;
        do {
            if ((b = (AbstractBuild)b.getPreviousBuild()) == null) {
                return null;
            }
            r = (DrMemoryBuildAction)b.getAction(DrMemoryBuildAction.class);
            if (r == null || r.getResult() != null) continue;
            r = null;
        } while (r == null);
        return r;
    }

    public DrMemoryBuildAction getPreviousResult() {
        return DrMemoryBuildAction.getPreviousResult(this.build);
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String type = req.getParameter("type");
        logger.fine("Graphing " + type);
        int width = 500;
        int height = 200;
        String w = req.getParameter("width");
        String h = req.getParameter("height");
        if (w != null && w.length() > 0) {
            width = Integer.parseInt(w);
        }
        if (h != null && h.length() > 0) {
            height = Integer.parseInt(h);
        }
        if (type == null) {
            throw new IOException("No type given");
        }
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        boolean latest = true;
        String yaxis = "???";
        float min = 1.0E9f;
        float max = 0.0f;
        AbstractGraph g = this.publisher.getGraphTypes().get(type);
        if (g == null) {
            rsp.sendError(1);
            return;
        }
        for (DrMemoryBuildAction a = this; a != null; a = a.getPreviousResult()) {
            logger.finest("Build " + a.getDisplayName());
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.build);
            float[] ns = g.getNumber(a);
            g.addX((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dsb, ns, label);
            for (float n : ns) {
                if (n > max) {
                    max = n;
                }
                if (n < min) {
                    min = n;
                }
                if (!latest) continue;
                yaxis = g.getYAxis();
            }
            latest = false;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build(), g.getTitle(), yaxis, (int)max, (int)min), (int)width, (int)height);
    }

    private JFreeChart createChart(CategoryDataset dataset, String title, String yaxis, int max, int min) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, null, (String)yaxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound((double)max);
        rangeAxis.setLowerBound((double)min);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static enum GraphType {
        TOTAL_LEAK;

    }
}

