/*
 * Decompiled with CFR 0.152.
 */
package com.sendcloud.sdk.core;

import com.sendcloud.sdk.config.Config;
import com.sendcloud.sdk.config.Credential;
import com.sendcloud.sdk.exception.SmsException;
import com.sendcloud.sdk.exception.VoiceException;
import com.sendcloud.sdk.model.Attachment;
import com.sendcloud.sdk.model.Content;
import com.sendcloud.sdk.model.MailAddressReceiver;
import com.sendcloud.sdk.model.SendCloudMail;
import com.sendcloud.sdk.model.SendCloudSms;
import com.sendcloud.sdk.model.SendCloudVoice;
import com.sendcloud.sdk.model.TemplateContent;
import com.sendcloud.sdk.model.TextContent;
import com.sendcloud.sdk.util.HttpUtil;
import com.sendcloud.sdk.util.Md5Util;
import com.sendcloud.sdk.util.ResponseData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.UUID;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.Asserts;

public class SendCloud {
    private String server;
    private String mailAPI;
    private String templateAPI;
    private String smsAPI;
    private String voiceAPI;

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getMailAPI() {
        return this.mailAPI;
    }

    public void setMailAPI(String mailAPI) {
        this.mailAPI = mailAPI;
    }

    public String getTemplateAPI() {
        return this.templateAPI;
    }

    public void setTemplateAPI(String templateAPI) {
        this.templateAPI = templateAPI;
    }

    public String getSmsAPI() {
        return this.smsAPI;
    }

    public void setSmsAPI(String smsAPI) {
        this.smsAPI = smsAPI;
    }

    public String getVoiceAPI() {
        return this.voiceAPI;
    }

    public void setVoiceAPI(String voiceAPI) {
        this.voiceAPI = voiceAPI;
    }

    public ResponseData sendMail(SendCloudMail mail) throws Throwable {
        Asserts.notNull((Object)mail, (String)"mail");
        Asserts.notBlank((CharSequence)Config.api_user, (String)"api_user");
        Asserts.notBlank((CharSequence)Config.api_key, (String)"api_key");
        mail.validate();
        Credential credential = new Credential(Config.api_user, Config.api_key);
        if (CollectionUtils.isEmpty(mail.getBody().getAttachments())) {
            return this.post(credential, mail);
        }
        return this.multipartPost(credential, mail);
    }

    private ResponseData post(Credential credential, SendCloudMail mail) throws ClientProtocolException, IOException {
        Content content;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("apiUser", credential.getApiUser()));
        params.add(new BasicNameValuePair("apiKey", credential.getApiKey()));
        params.add(new BasicNameValuePair("from", mail.getBody().getFrom()));
        params.add(new BasicNameValuePair("fromName", mail.getBody().getFromName()));
        params.add(new BasicNameValuePair("subject", mail.getBody().getSubject()));
        params.add(new BasicNameValuePair("replyTo", mail.getBody().getReplyTo()));
        if (mail.getBody().getLabelId() != null) {
            params.add(new BasicNameValuePair("labelId", mail.getBody().getLabelId().toString()));
        }
        if (mail.getContent().useTemplate()) {
            content = (TemplateContent)mail.getContent();
            params.add(new BasicNameValuePair("templateInvokeName", ((TemplateContent)content).getTemplateInvokeName()));
        } else {
            content = (TextContent)mail.getContent();
            if (((TextContent)content).getContent_type().equals((Object)TextContent.ScContentType.html)) {
                params.add(new BasicNameValuePair("html", ((TextContent)content).getText()));
            } else {
                params.add(new BasicNameValuePair("plain", ((TextContent)content).getText()));
            }
        }
        if (mail.getTo() != null) {
            if (mail.getTo().useAddressList()) {
                params.add(new BasicNameValuePair("useAddressList", "true"));
                params.add(new BasicNameValuePair("to", mail.getTo().toString()));
            } else {
                MailAddressReceiver receiver = (MailAddressReceiver)mail.getTo();
                if (!mail.getContent().useTemplate() && receiver.isBroadcastSend()) {
                    params.add(new BasicNameValuePair("to", receiver.toString()));
                    params.add(new BasicNameValuePair("cc", receiver.getCcString()));
                    params.add(new BasicNameValuePair("bcc", receiver.getBccString()));
                } else if (mail.getBody().getXsmtpapi() != null && !mail.getBody().getXsmtpapi().containsKey("to")) {
                    mail.getBody().addXsmtpapi("to", JSONArray.fromObject(receiver.getTo()));
                }
            }
        }
        if (MapUtils.isNotEmpty(mail.getBody().getHeaders())) {
            params.add(new BasicNameValuePair("headers", mail.getBody().getHeadersString()));
        }
        if (MapUtils.isNotEmpty(mail.getBody().getXsmtpapi())) {
            params.add(new BasicNameValuePair("xsmtpapi", mail.getBody().getXsmtpapiString()));
        }
        params.add(new BasicNameValuePair("respEmailId", "true"));
        params.add(new BasicNameValuePair("useNotification", "false"));
        HttpPost httpPost = new HttpPost(mail.getContent().useTemplate() ? this.templateAPI : this.mailAPI);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        return HttpUtil.post(httpPost);
    }

    private ResponseData multipartPost(Credential credential, SendCloudMail mail) throws ClientProtocolException, IOException {
        Content content;
        HttpPost httpPost = new HttpPost(mail.getContent().useTemplate() ? this.templateAPI : this.mailAPI);
        MultipartEntityBuilder entity = MultipartEntityBuilder.create();
        entity.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entity.setCharset(Charset.forName("UTF-8"));
        ContentType TEXT_PLAIN = ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8"));
        entity.addTextBody("apiUser", credential.getApiUser(), TEXT_PLAIN);
        entity.addTextBody("apiKey", credential.getApiKey(), TEXT_PLAIN);
        entity.addTextBody("from", mail.getBody().getFrom(), TEXT_PLAIN);
        if (StringUtils.isNotEmpty((String)mail.getBody().getFromName())) {
            entity.addTextBody("fromName", mail.getBody().getFromName(), TEXT_PLAIN);
        }
        entity.addTextBody("subject", mail.getBody().getSubject(), TEXT_PLAIN);
        if (StringUtils.isNotEmpty((String)mail.getBody().getReplyTo())) {
            entity.addTextBody("replyTo", mail.getBody().getReplyTo(), TEXT_PLAIN);
        }
        if (mail.getBody().getLabelId() != null) {
            entity.addTextBody("labelId", mail.getBody().getLabelId().toString(), TEXT_PLAIN);
        }
        if (mail.getContent().useTemplate()) {
            content = (TemplateContent)mail.getContent();
            entity.addTextBody("templateInvokeName", ((TemplateContent)content).getTemplateInvokeName(), TEXT_PLAIN);
        } else {
            content = (TextContent)mail.getContent();
            if (((TextContent)content).getContent_type().equals((Object)TextContent.ScContentType.html)) {
                entity.addTextBody("html", ((TextContent)content).getText(), TEXT_PLAIN);
            } else {
                entity.addTextBody("plain", ((TextContent)content).getText(), TEXT_PLAIN);
            }
        }
        if (mail.getTo() != null) {
            if (mail.getTo().useAddressList()) {
                entity.addTextBody("useAddressList", "true", TEXT_PLAIN);
                entity.addTextBody("to", mail.getTo().toString(), TEXT_PLAIN);
            } else {
                MailAddressReceiver receiver = (MailAddressReceiver)mail.getTo();
                if (!mail.getContent().useTemplate() && receiver.isBroadcastSend()) {
                    entity.addTextBody("to", receiver.toString(), TEXT_PLAIN);
                    if (StringUtils.isNotEmpty((String)receiver.getCcString())) {
                        entity.addTextBody("cc", receiver.getCcString(), TEXT_PLAIN);
                    }
                    if (StringUtils.isNotEmpty((String)receiver.getBccString())) {
                        entity.addTextBody("bcc", receiver.getBccString(), TEXT_PLAIN);
                    }
                } else if (mail.getBody().getXsmtpapi() == null || !mail.getBody().getXsmtpapi().containsKey("to")) {
                    mail.getBody().addXsmtpapi("to", JSONArray.fromObject(receiver.getTo()));
                }
            }
        }
        if (MapUtils.isNotEmpty(mail.getBody().getHeaders())) {
            entity.addTextBody("headers", mail.getBody().getHeadersString(), TEXT_PLAIN);
        }
        if (MapUtils.isNotEmpty(mail.getBody().getXsmtpapi())) {
            entity.addTextBody("xsmtpapi", mail.getBody().getXsmtpapiString(), TEXT_PLAIN);
        }
        entity.addTextBody("respEmailId", "true", TEXT_PLAIN);
        entity.addTextBody("useNotification", "false", TEXT_PLAIN);
        ContentType OCTEC_STREAM = ContentType.create((String)"application/octet-stream", (Charset)Charset.forName("UTF-8"));
        for (Object o : mail.getBody().getAttachments()) {
            if (o instanceof File) {
                entity.addBinaryBody("attachments", (File)o, OCTEC_STREAM, ((File)o).getName());
                continue;
            }
            if (o instanceof Attachment) {
                entity.addBinaryBody("attachments", ((Attachment)o).getContent(), OCTEC_STREAM, ((Attachment)o).getName());
                continue;
            }
            entity.addBinaryBody("attachments", (InputStream)o, OCTEC_STREAM, UUID.randomUUID().toString());
        }
        httpPost.setEntity(entity.build());
        return HttpUtil.post(httpPost);
    }

    public ResponseData sendSms(SendCloudSms sms) throws ClientProtocolException, IOException, SmsException {
        Asserts.notNull((Object)sms, (String)"sms");
        Asserts.notBlank((CharSequence)Config.sms_user, (String)"sms_user");
        Asserts.notBlank((CharSequence)Config.sms_key, (String)"sms_key");
        sms.validate();
        Credential credential = new Credential(Config.sms_user, Config.sms_key);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("smsUser", credential.getApiUser());
        treeMap.put("msgType", sms.getMsgType().toString());
        treeMap.put("phone", sms.getPhoneString());
        treeMap.put("templateId", sms.getTemplateId().toString());
        treeMap.put("timestamp", String.valueOf(new Date().getTime()));
        if (MapUtils.isNotEmpty(sms.getVars())) {
            treeMap.put("vars", sms.getVarsString());
        }
        String signature = Md5Util.md5Signature(treeMap, credential.getApiKey());
        treeMap.put("signature", signature);
        Iterator<String> iterator = treeMap.keySet().iterator();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        while (iterator.hasNext()) {
            String key = iterator.next();
            params.add(new BasicNameValuePair(key, treeMap.get(key)));
        }
        HttpPost httpPost = new HttpPost(this.smsAPI);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        return HttpUtil.post(httpPost);
    }

    public ResponseData sendVoice(SendCloudVoice voice) throws VoiceException, ParseException, IOException {
        Asserts.notNull((Object)voice, (String)"voice");
        Asserts.notBlank((CharSequence)Config.sms_user, (String)"sms_user");
        Asserts.notBlank((CharSequence)Config.sms_key, (String)"sms_key");
        voice.validate();
        Credential credential = new Credential(Config.sms_user, Config.sms_key);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("smsUser", credential.getApiUser());
        treeMap.put("phone", voice.getPhone());
        treeMap.put("code", voice.getCode());
        treeMap.put("timestamp", String.valueOf(new Date().getTime()));
        String signature = Md5Util.md5Signature(treeMap, credential.getApiKey());
        treeMap.put("signature", signature);
        Iterator<String> iterator = treeMap.keySet().iterator();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        while (iterator.hasNext()) {
            String key = iterator.next();
            params.add(new BasicNameValuePair(key, treeMap.get(key)));
        }
        HttpPost httpPost = new HttpPost(this.voiceAPI);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        return HttpUtil.post(httpPost);
    }
}

