/*
 * Decompiled with CFR 0.152.
 */
package com.sendcloud.sdk.model;

import com.sendcloud.sdk.exception.ReceiverException;
import com.sendcloud.sdk.model.Receiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class AddressListReceiver
implements Receiver {
    private List<String> invokeNames = new ArrayList<String>();

    @Override
    public boolean useAddressList() {
        return true;
    }

    public List<String> getInvokeNames() {
        return this.invokeNames;
    }

    public void addTo(String to) {
        this.invokeNames.addAll(Arrays.asList(to.split(";")));
    }

    @Override
    public boolean validate() throws ReceiverException {
        if (CollectionUtils.isEmpty(this.invokeNames)) {
            throw new ReceiverException("\u5730\u5740\u5217\u8868\u4e3a\u7a7a");
        }
        if (this.invokeNames.size() > 5) {
            throw new ReceiverException("\u5730\u5740\u5217\u8868\u8d85\u8fc7\u4e0a\u9650");
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String address : this.invokeNames) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(address);
        }
        return sb.toString();
    }
}

