/*
 * Decompiled with CFR 0.152.
 */
package com.sendcloud.sdk.model;

import com.sendcloud.sdk.exception.ReceiverException;
import com.sendcloud.sdk.model.Receiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class MailAddressReceiver
implements Receiver {
    public boolean broadcastSend = true;
    private List<String> to;
    private List<String> cc;
    private List<String> bcc;

    public List<String> getTo() {
        return this.to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public void addTo(String address) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.addAll(Arrays.asList(address.split(";")));
    }

    public void addCc(String address) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.addAll(Arrays.asList(address.split(";")));
    }

    public void addBcc(String address) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.addAll(Arrays.asList(address.split(";")));
    }

    public boolean isBroadcastSend() {
        return this.broadcastSend;
    }

    public void setBroadcastSend(boolean broadcastSend) {
        this.broadcastSend = broadcastSend;
    }

    @Override
    public boolean useAddressList() {
        return false;
    }

    @Override
    public boolean validate() throws ReceiverException {
        if (CollectionUtils.isEmpty(this.to)) {
            throw new ReceiverException("\u6536\u4ef6\u4eba\u4e3a\u7a7a");
        }
        int receivers = this.to.size();
        if (CollectionUtils.isNotEmpty(this.cc)) {
            receivers += this.cc.size();
        }
        if (CollectionUtils.isNotEmpty(this.bcc)) {
            receivers += this.bcc.size();
        }
        if (receivers > 100) {
            throw new ReceiverException("\u6536\u4ef6\u4eba\u8d85\u51fa\u4e0a\u9650");
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String address : this.to) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(address);
        }
        return sb.toString();
    }

    public String getCcString() {
        if (CollectionUtils.isEmpty(this.cc)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String address : this.cc) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(address);
        }
        return sb.toString();
    }

    public String getBccString() {
        if (CollectionUtils.isEmpty(this.bcc)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String address : this.bcc) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(address);
        }
        return sb.toString();
    }
}

