/*
 * Decompiled with CFR 0.152.
 */
package com.sendcloud.sdk.model;

import com.sendcloud.sdk.exception.SmsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.http.util.Asserts;

public class SendCloudSms {
    public Integer templateId;
    public Integer msgType = 0;
    public List<String> phone;
    public Map<String, String> vars;

    public Integer getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public List<String> getPhone() {
        return this.phone;
    }

    public String getPhoneString() {
        Asserts.notNull(this.phone, (String)"phone");
        StringBuilder sb = new StringBuilder();
        for (String p : this.phone) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p);
        }
        return sb.toString();
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public String getVarsString() {
        Asserts.notNull(this.vars, (String)"vars");
        return JSONObject.fromObject(this.vars).toString();
    }

    public void addPhone(String mobile) {
        if (CollectionUtils.isEmpty(this.phone)) {
            this.phone = new ArrayList<String>();
        }
        this.phone.add(mobile);
    }

    public void addVars(String key, String value) {
        if (MapUtils.isEmpty(this.vars)) {
            this.vars = new HashMap<String, String>();
        }
        this.vars.put(key, value);
    }

    public boolean validate() throws SmsException {
        if (this.templateId == null) {
            throw new SmsException("\u6a21\u7248\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(this.phone)) {
            throw new SmsException("\u6536\u4fe1\u4eba\u4e3a\u7a7a");
        }
        if (this.phone.size() > 100) {
            throw new SmsException("\u6536\u4fe1\u4eba\u8d85\u8fc7\u9650\u5236");
        }
        return true;
    }
}

