/*
 * Decompiled with CFR 0.152.
 */
package com.sendcloud.sdk.util;

import com.sendcloud.sdk.util.ResponseData;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static PoolingHttpClientConnectionManager connManager = null;
    private static CloseableHttpClient httpClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseData post(HttpPost httpPost) throws ClientProtocolException, IOException {
        try (CloseableHttpResponse response = null;){
            response = httpClient.execute((HttpUriRequest)httpPost);
            ResponseData responseData = HttpUtil.validate((HttpResponse)response);
            return responseData;
        }
    }

    public static void destroy() {
        try {
            System.out.println("destroy httpClient");
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    private static ResponseData validate(HttpResponse response) throws ParseException, IOException {
        ResponseData result = new ResponseData();
        if (response != null && response.getEntity() != null) {
            String s = EntityUtils.toString((HttpEntity)response.getEntity());
            if (JSONUtils.mayBeJSON((String)s)) {
                JSONObject json = JSONObject.fromObject((Object)s);
                if (json.containsKey((Object)"statusCode")) {
                    result.setStatusCode(json.getInt("statusCode"));
                    result.setMessage(json.getString("message"));
                    result.setResult(json.getBoolean("result"));
                    result.setInfo(json.getJSONObject("info").toString());
                } else {
                    result.setStatusCode(500);
                    result.setMessage(json.toString());
                }
            } else {
                result.setStatusCode(response.getStatusLine().getStatusCode());
                result.setMessage("\u53d1\u9001\u5931\u8d25");
                result.setResult(false);
            }
        } else {
            result.setStatusCode(500);
            result.setMessage("\u53d1\u9001\u5931\u8d25");
            result.setResult(false);
        }
        return result;
    }

    static {
        SSLContext sslcontext = null;
        try {
            sslcontext = SSLContexts.custom().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(1000);
        connManager.setDefaultMaxPerRoute(100);
        connManager.setValidateAfterInactivity(2000);
        int connection_timeout = 10000;
        int so_timeout = 10000;
        RequestConfig config = RequestConfig.custom().setSocketTimeout(so_timeout).setConnectionRequestTimeout(connection_timeout).setConnectTimeout(connection_timeout).setCookieSpec("ignoreCookies").build();
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(config).setDefaultHeaders(Arrays.asList(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Safari/537.36"), new BasicHeader("charset", "utf-8"), new BasicHeader("Connection", "close"))).build();
    }
}

